package systems.dennis.auth.form;

import lombok.Data;
import systems.dennis.shared.annotations.Validation;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.DEFAULT_TYPES;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.validation.EmailValidator;
import systems.dennis.shared.validation.PasswordValidator;
import systems.dennis.shared.validation.ValueNotEmptyValidator;

@Data
public class RegistrationForm implements DefaultForm {
    @Validation(ValueNotEmptyValidator.class)
    @PojoFormElement (required = true)
    private String name;

    @Validation({EmailValidator.class})
    @PojoFormElement ( required = true, validators = EmailValidator.class)
    private String email;

    @Validation({ValueNotEmptyValidator.class, PasswordValidator.class})
    @PojoFormElement (required = true, type = DEFAULT_TYPES.PASSWORD, validators =  PasswordValidator.class)
    private String password;

    @Validation({ValueNotEmptyValidator.class, PasswordValidator.class})
    @PojoFormElement (required = true, type = DEFAULT_TYPES.PASSWORD)
    private String repeatPassword;

    @Override
    public Long getId() {
        return null;
    }


    @Override
    public String asValue() {
        return name;
    }
}
