package systems.dennis.auth.config;

import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import systems.dennis.auth.client.required.TokenProviderClient;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.scopes.service.ScopeService;

@Service
@Primary
public class AuthorizationPrimaryTokenProvider extends TokenProviderClient {
    public AuthorizationPrimaryTokenProvider(WebContext context) {
        super(context);
    }

    public String getSecretKey(String scope){
        return getContext().getBean(ScopeService.class).findByName(scope, null, true).getSecretKey();
    }
}
