package systems.dennis.auth.config;

import jakarta.servlet.http.HttpServletRequest;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.form.ChangePasswordForm;
import systems.dennis.auth.form.RegistrationForm;
import systems.dennis.auth.role_validator.entity.UserTokenDTO;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.scopes.model.ScopeModel;

public interface AuthorizationDelegator {
    String AUTH_TYPE_HEADER = "AUTH_TYPE";
    String AUTH_SCOPE_HEADER = "AUTH_SCOPE";

    AuthorizeResponse authorize(HttpServletRequest request, LoginPassword password, WebContext.LocalWebContext context);

    boolean shouldAuthorize(HttpServletRequest request, WebContext.LocalWebContext context);


    boolean blockUser(boolean toBlock, Long userDataId, WebContext.LocalWebContext context);

    boolean logout(String token, WebContext.LocalWebContext context, ScopeModel scopeModel);

    boolean register(RegistrationForm form, WebContext.LocalWebContext context, ScopeModel scopeModel, Long invitationId);

    void validate(UserTokenDTO dto, WebContext.LocalWebContext context);

    boolean changePassword(HttpServletRequest req, WebContext.LocalWebContext context, ChangePasswordForm loginPassword, ScopeModel scopeModel);

    String forgetPassword(HttpServletRequest req, WebContext.LocalWebContext context, String login);

    default boolean requestAuthorization(HttpServletRequest req, WebContext.LocalWebContext context, String login){
        return true;
    }
    default boolean requestRegistration(HttpServletRequest req, WebContext.LocalWebContext context, String login){
        return true;
    }

    default boolean resendCode(HttpServletRequest req, WebContext.LocalWebContext context, String login, String type) {
        return true;
    }
}
