package systems.dennis.auth.validators;

import systems.dennis.auth.form.RegistrationForm;
import systems.dennis.auth.role_validator.entity.UserTokenDTO;
import systems.dennis.shared.annotations.security.selfchecker.AbstractSelfChecker;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.AccessDeniedException;
import systems.dennis.shared.utils.security.AbstractAuthorizationProvider;

public class LoginPasswordSelfChecker implements AbstractSelfChecker<RegistrationForm> {

    @Override
    public void check(AbstractAuthorizationProvider dto, RegistrationForm object, WebContext.LocalWebContext context) {
        if (object == null) return;
        if (!(dto instanceof UserTokenDTO)) {
            throw new AccessDeniedException("User has not access to object ");
        }

        final UserTokenDTO tokenDTO = (UserTokenDTO) dto;

        if (!tokenDTO.getUserData().getLogin().equals(object.getEmail())) {
            throw new AccessDeniedException("User has not access to object ");
        }
    }
}
