package systems.dennis.auth.service;

import org.springframework.stereotype.Service;
import systems.dennis.auth.entity.VirtualLoginPassword;
import systems.dennis.auth.form.VirtualLoginPasswordForm;
import systems.dennis.auth.repository.VirtualLoginPasswordRepo;
import systems.dennis.auth.util.PasswordService;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.forms.QueryObject;
import systems.dennis.shared.postgres.service.PaginationService;
import systems.dennis.shared.repository.AbstractDataFilter;


import java.util.Collections;
import java.util.List;

@Service
@DataRetrieverDescription(model = VirtualLoginPassword.class, form = VirtualLoginPasswordForm.class, repo = VirtualLoginPasswordRepo.class)
public class VirtualLoginPasswordService extends PaginationService<VirtualLoginPassword> {
    private final PasswordService service;

    public VirtualLoginPasswordService(WebContext holder, PasswordService service) {
        super(holder);
        this.service = service;
    }


    public VirtualLoginPassword create() {
        VirtualLoginPassword password = new VirtualLoginPassword();
        var pass = service.generateRandomPassword(15);
        password.setPassword(service.toPassword(pass));
        var userName = service.generateRandomUsername();
        password.setName(userName);
        password.setIsActive(true);
        password.setTmp(pass);
        var res = super.save(password);
        res.setPassword(pass);
        return res;
    }

    public void markViewed(VirtualLoginPassword virtualLoginPassword) {
        if (virtualLoginPassword.getId() == null) {
            throw new IllegalArgumentException("Password id should not be null");
        }
        virtualLoginPassword.setTmp("");
        virtualLoginPassword.setViewed(true);
        getRepository().save(virtualLoginPassword);
    }

    public AbstractDataFilter<VirtualLoginPassword> getAdditionalCases(QueryObject<String> parameters) {
        if (!getUtils().hasRole("ROLE_ADMIN_VIEW_ALL_VD")) {

            return getFilterImpl().eq("userDataId", getCurrentUser());
        } else {
            return getFilterImpl().empty();
        }
    }
}
