package systems.dennis.auth.service;

import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import systems.dennis.auth.entity.ActiveToken;
import systems.dennis.auth.form.TempAccountForm;
import systems.dennis.auth.model.TempAccount;
import systems.dennis.auth.repository.ActiveTokensRepo;
import systems.dennis.auth.repository.TempAccountRepo;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.postgres.service.PaginationService;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.repository.AbstractRepository;

import java.util.Date;

@Service
@DataRetrieverDescription(model = TempAccount.class, form = TempAccountForm.class, repo = TempAccountRepo.class)
public class TempAccountService extends PaginationService<TempAccount> {

    public TempAccountService(WebContext holder) {
        super(holder);
    }

    @Override
    public TempAccountRepo getRepository() {
        return getContext().getBean(TempAccountRepo.class);
    }

    public Page<TempAccount> getExpiredAccounts(Integer limit, Integer page) {
        Date now = new Date();
        AbstractDataFilter<TempAccount> filter = getFilterImpl().lessEQ("expiryDate", now).and(getNotDeletedQuery());
        return find(filter, limit, page);
    }

    public TempAccount findByLogin(String login) {
        AbstractDataFilter<TempAccount> filter = getFilterImpl().lessEQ("login", login).and(getNotDeletedQuery());
        return getRepository().filteredFirst(filter).orElseThrow(() -> new ItemNotFoundException(login));
    }
}
