package systems.dennis.auth.service;

import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.form.ChangePasswordForm;
import systems.dennis.auth.repository.LoginPasswordRepo;
import systems.dennis.auth.util.PasswordService;

@Service
@DataRetrieverDescription(model = LoginPassword.class, form = ChangePasswordForm.class, repo = LoginPasswordRepo.class)
public class ChangePasswordServiceImpl extends UsersPageService {
    public ChangePasswordServiceImpl( WebContext context) {
        super(  context);
    }


    @Override
    public LoginPassword preEdit(LoginPassword object, LoginPassword original) throws UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        var res =  super.preEdit(object, original);

        res.setPassword(getContext().getBean(PasswordService.class).toPassword(res.getPassword()));
        return res;
    }

    public void changePassword(LoginPassword lp) {
        LoginPasswordRepo repo = getRepository();
        var newlp = repo.findByLogin(lp.getLogin()).orElseThrow(()-> ItemNotFoundException.fromId(lp.getLogin()));
        newlp.setPassword(lp.getPassword());
        save(newlp);
    }
}
