package systems.dennis.auth.model;

import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import lombok.Data;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.shared.postgres.model.BaseEntity;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;

import java.util.Date;

@Data
@Entity
public class VerificationTokenModel extends BaseEntity {

    private String token;

    @ManyToOne
    private UserData userData;

    @DataTransformer(transFormWith = DateAndStringConverter.class, params = "HH:mm dd.MM.yyyy")
    private Date expirationDate;

    @Override
    public String asValue() {
        return token + expirationDate.getTime();
    }
}
