package systems.dennis.auth.model;

import jakarta.persistence.Entity;
import lombok.Data;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.postgres.model.BaseEntity;

import java.util.Date;

@Data
@Entity
@DeleteStrategy (DeleteStrategy.DELETE_STRATEGY_PROPERTY)
public class TempAccount extends BaseEntity {

    private String code;
    private String login;
    private Boolean enabled;
    private Date expiryDate;

    @Override
    public String asValue() {
        return "code";
    }
}
