package systems.dennis.auth.form;

import lombok.Data;
import systems.dennis.shared.pojo_form.Checkable;
import systems.dennis.shared.pojo_form.FormTitle;
import systems.dennis.shared.pojo_form.PojoForm;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.pojo_view.list.Remote;
import systems.dennis.shared.postgres.form.DefaultForm;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.*;

@Data
@PojoListView (actions = {"download",  "generateVirtualUser", "settings"})
@PojoForm(title = @FormTitle(show = true))

public class VirtualLoginPasswordForm implements DefaultForm {

    @PojoFormElement(type = HIDDEN, showLabel = false)
    private Long id;

    @PojoListViewField(searchable = true)
    @PojoFormElement(type = TEXT)
    private String name;

    @PojoFormElement(type = CHECKBOX, remote = @Remote(searchType = CHECKBOX), checked = @Checkable(checked = true))
    @PojoListViewField (searchable = true)
    private Boolean isActive = Boolean.TRUE;

    @PojoListViewField(actions = {@UIAction(component = "delete", allowOnMultipleRows = true)})
    @PojoFormElement(visible = false)
    private Integer actions;
}
