package systems.dennis.auth.form;

import lombok.Data;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.pojo_view.list.Remote;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.DATE;
import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.HIDDEN;

@Data
@PojoListView
public class VerificationTokenForm implements DefaultForm {

    @PojoFormElement(type = HIDDEN)
    private Long id;

    private String token;

    @ObjectByIdPresentation
    private Long userData;

    @PojoFormElement(type = DATE)
    @PojoListViewField(searchable = true, type = DATE, remote = @Remote(searchType = DATE))
    @DataTransformer(transFormWith = DateAndStringConverter.class, params = "HH:mm dd.MM.yyyy")
    private String expirationDate;
}
