package systems.dennis.auth.form;

import lombok.Data;
import systems.dennis.shared.pojo_form.Checkable;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.UIActionParameter;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.postgres.form.DefaultForm;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.*;

@Data
@PojoListView(showId = true)
public class LoginPasswordForm implements DefaultForm {


    @PojoFormElement(type = HIDDEN)
    @PojoListViewField(widthInTable = "100px")
    private Long id;

    @PojoListViewField(searchable = false)
    @PojoFormElement (type = LABEL)
    private String login;

    @PojoListViewField(searchable = false, visible = false)
    @PojoFormElement(type = HIDDEN)
    private String password;

    @PojoFormElement(type = HIDDEN)
    private String twoFactorCode;

    @PojoFormElement(type = CHECKBOX, checked = @Checkable())
    private Boolean twoFactor;

    @PojoListViewField(showContent = false, actions = {@UIAction(component = "edit.html", parameters = {
            @UIActionParameter(key = "path", value = "/auth/users")
    }),
            @UIAction(component = "link_to_profile.html", parameters = {
                    @UIActionParameter(key = "path", value = "/auth/profile/view/login")
            }),
            @UIAction(component = "delete.html", parameters = {
                    @UIActionParameter(key = "path", value = "/api/v2/auth/profile")
            }),

    })
    @PojoFormElement(visible = false)
    private Integer actions;

    @Override
    public String asValue() {
        return login;
    }
}
