package systems.dennis.auth.form;

import systems.dennis.auth.service.LoginPasswordService;
import systems.dennis.shared.annotations.ValidationContent;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.validation.ValueValidator;
import systems.dennis.shared.pojo_form.ValidationResult;
import systems.dennis.auth.client.utils.SecurityUtils;
import systems.dennis.auth.util.PasswordService;

public class CurrentPasswordValidator implements ValueValidator<ChangePasswordForm, String> {
    @Override
    public ValidationResult validate(ChangePasswordForm element, String value, ValidationContent content) {

        try {
            var ps = content.getContext().getBean(PasswordService.class);
            var res = content.getContext().getBean(LoginPasswordService.class).login(content.getContext().getBean(SecurityUtils.class).get().getUserData().getLogin(), ps.toPassword(element.getCurrentPassword()), element.getCode());
            if (res.isEmpty()) {
                return ValidationResult.fail("wrong_password_or_authcode");
            }
        } catch (Exception e){
            return ValidationResult.fail("wrong_password_or_authcode");
        }

        return ValidationResult.PASSED;
    }
}
