package systems.dennis.auth.delegations.simple;

import lombok.extern.slf4j.Slf4j;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.entity.ActiveToken;
import systems.dennis.auth.entity.LoginHistory;
import systems.dennis.auth.repository.LoginHistoryRepository;
import systems.dennis.auth.repository.UserDataRepository;
import systems.dennis.auth.role_validator.TokenProvider;
import systems.dennis.auth.role_validator.entity.UserRole;
import systems.dennis.auth.role_validator.entity.UserTokenDTO;
import systems.dennis.auth.service.LoginPasswordService;
import systems.dennis.auth.service.UserInScopeService;
import systems.dennis.auth.util.PasswordService;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.AuthorizationFailedException;
import systems.dennis.shared.scopes.model.ScopeModel;

import java.util.Optional;
import java.util.stream.Collectors;

@Slf4j
public class SimplePhoneAuthorization  extends SimpleTokenAuthorization{
    @Override
    public UserTokenDTO authorize(LoginPassword res, WebContext.LocalWebContext context, ScopeModel scope) {

        var passwordService = context.getBean(PasswordService.class);
        var tokenProvider = context.getBean(TokenProvider.class);




        UserData userData = createUser(res, context);

        UserTokenDTO dto = new UserTokenDTO();
        dto.setUserData(userData);
        log.debug("Authorization ->  , creating token: {}", res.getLogin());
        var roles = passwordService.getRoles(res, scope);
        var token = tokenProvider.createToken(dto, ActiveToken.DEFAULT_PHONE_TYPE, roles, scope);
        dto.setToken(token.getToken());
        dto.setDue(token.getDue());
        dto.setRoles(roles.stream().map(UserRole::getRole).collect(Collectors.toList()));

        saveLoginAttempt(dto, context);
        return dto;


    }


}
