package systems.dennis.auth.delegations.simple;

import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.role_validator.entity.UserTokenDTO;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.scopes.model.ScopeModel;

public interface AuthorizationAttemptProcessor {
    <T extends UserTokenDTO> T authorize(LoginPassword loginPassword, WebContext.LocalWebContext context, ScopeModel scope);

    <T extends UserData> T createUser(LoginPassword loginPassword, WebContext.LocalWebContext context);
    void saveLoginAttempt(UserTokenDTO loginPassword, WebContext.LocalWebContext context);

}
