package systems.dennis.auth.controller;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.auth.entity.Subscription;
import systems.dennis.auth.form.SubscriptionForm;
import systems.dennis.auth.service.SubscriptionService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.*;
import systems.dennis.shared.postgres.controller.AddItemController;
import systems.dennis.shared.postgres.controller.DeleteItemController;
import systems.dennis.shared.postgres.controller.EditItemController;
import systems.dennis.shared.postgres.controller.ListItemController;
import systems.dennis.shared.utils.ApplicationContext;

@RestController
@RequestMapping("/api/v2/auth/subscriptions")
@Secured (roles = "ROLE_ADMIN")
@CrossOrigin
@WebFormsSupport(SubscriptionService.class)
public class SubscriptionDataController extends ApplicationContext implements
        DeleteItemController<Subscription>,
        AddItemController<Subscription, SubscriptionForm>,
        EditItemController<Subscription, SubscriptionForm>,
        ListItemController<Subscription, SubscriptionForm> {

    public SubscriptionDataController(WebContext context) {
        super(context);
    }

    @Override
    @WithRole ("ROLE_ADMIN")
    public ResponseEntity<SubscriptionForm> edit(SubscriptionForm form) throws ItemForAddContainsIdException, ItemDoesNotContainsIdValueException, UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        return EditItemController.super.edit(form);
    }


    @Override
    @WithRole ("ROLE_ADMIN")
    public void delete(Long id) throws ItemNotUserException, ItemNotFoundException {
        DeleteItemController.super.delete(id);
    }


}
