package systems.dennis.auth.controller;

import lombok.SneakyThrows;
import org.springframework.web.bind.annotation.*;
import systems.dennis.auth.role_validator.entity.RolesToUser;
import systems.dennis.auth.service.LoginPasswordService;

import java.util.List;

@RestController
@RequestMapping ("/api/v2/users")
public class RemoteUserController {

    private final LoginPasswordService service;

    public RemoteUserController(LoginPasswordService service) {
        this.service = service;
    }

    @GetMapping ("/search")
    public List<String> search(@RequestParam (required = false, value = "term") String text){
        return service.findUsersByLogin(text);
    }

    @SneakyThrows
    @GetMapping ("/user_role/{login}/{roleId}")
    public RolesToUser getUserAssigment(@PathVariable String login, @PathVariable Long roleId) {
        var item = service.findUserAssigment(login, roleId).orElse(null);

        if (item == null ) return item;

        item.setPassword(null);
        return item;

    }

    @PostMapping("/insert/{roleId}/{userLogin}")
    public RolesToUser insert(@PathVariable String userLogin, @PathVariable Long roleId){
        return service.assignUser(userLogin, roleId);
    }

}
