package systems.dennis.auth.config;

import lombok.extern.slf4j.Slf4j;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.entity.UserInScopeModel;
import systems.dennis.auth.repository.LoginPasswordRepo;
import systems.dennis.auth.repository.UserDataRepository;
import systems.dennis.auth.repository.UserInScopeRepo;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.auth.service.UserInScopeService;
import systems.dennis.auth.util.PasswordService;
import systems.dennis.shared.beans.OnAppStart;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.scopes.model.ScopeModel;
import systems.dennis.shared.scopes.repository.ScopeRepo;
import systems.dennis.shared.scopes.service.ScopeService;

@Component
@Order(0)
@Slf4j
public class OnAppStartImpl implements OnAppStart {
    public void onAppRun(WebContext context){

        if (context.getBean(LoginPasswordRepo.class).count() == 0){
            //create user

            UserData data = new UserData();
            data.setLogin("admin");
            data.setEmail("admin");
            data.setName("admin");
            data.setBlocked(false);
            data.setVerified(true);

            context.getBean(UserDataRepository.class).save(data);


            try {
                LoginPassword lp = new LoginPassword();
                lp.setLogin(data.getLogin());
                lp.setPassword(context.getBean(PasswordService.class).toPassword(data.getLogin()));
                lp.setTwoFactor(false);
                context.getBean(LoginPasswordRepo.class).save(lp);
            } catch (Exception e){
                log.info(e.getMessage() + " CANNOT SAVE LP");
            }

        }
        var scopeService = context.getBean(ScopeRepo.class);
        if (scopeService.count() == 0) {
             UserData user = context.getBean(ProfilePageService.class).findByLogin("admin").get();

            ScopeModel scope = new ScopeModel();
            scope.setName("Default");
            scope.setDescription("Default");
            scope.setUserDataId(user.getId());
            scope = context.getBean(ScopeService.class).save(scope);

            UserInScopeModel userInScope = context.getBean(UserInScopeService.class).getByUserAndScope(user, scope);
            context.getBean(UserInScopeRepo.class).save(userInScope);
        }


    }
}
