package systems.dennis.auth.client;

import lombok.Data;
import systems.dennis.auth.form.RegistrationForm;


import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Transient;
import systems.dennis.shared.postgres.model.BaseEntity;

@Data
@Entity
public class LoginPassword extends BaseEntity {
    @Column (columnDefinition = "varchar(500)")
    private String login;
    @Column (columnDefinition = "varchar(2000)")
    private String password;

    private String domain;

    private Boolean twoFactor;

    private String twoFactorCode;

    public static LoginPassword from(RegistrationForm form) {
        LoginPassword loginPassword = new LoginPassword();
        loginPassword.setLogin(form.getEmail());
        loginPassword.setPassword(form.getPassword());
        loginPassword.setTwoFactor(Boolean.FALSE);
        return loginPassword;
    }

    @Transient
    private boolean updatable;

    @Override
    public String asValue() {
        return login;
    }
}
