package systems.dennis.auth.validators;

import systems.dennis.shared.annotations.ValidationContent;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.validation.ValueValidator;
import systems.dennis.shared.pojo_form.ValidationResult;
import systems.dennis.auth.form.RoleForm;
import systems.dennis.auth.service.RoleServiceImpl;

public class RoleExistsValidator implements ValueValidator<RoleForm, String> {
    @Override
    public ValidationResult validate(RoleForm element, String value, ValidationContent content) {
        var roleService = content.getContext().getBean(RoleServiceImpl.class);
        var res = roleService.existsByName(value);

        if (!res){

            return ValidationResult.PASSED;
        }

        if (content.isEdit()){

            var item = roleService.findFirstByName(element.getRole(), element.getId());

            if (item != null){
                return ValidationResult.PASSED;
            }

            return ValidationResult.fail("role_already_exists");
        } else {
            return  ValidationResult.fail("role_already_exists");
        }




    }
}
