package systems.dennis.auth.validators;

import systems.dennis.shared.annotations.ValidationContent;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.validation.ValueValidator;
import systems.dennis.shared.pojo_form.ValidationResult;
import systems.dennis.auth.form.ChangePasswordForm;

import java.util.regex.Pattern;

public class ChangePasswordValidator implements ValueValidator<ChangePasswordForm, String> {
    private final Pattern regex =Pattern.compile( "^(?=.*[0-9])(?=.*[a-z])(?=.*[A-Z])(?=.*[@#$%^&+=])(?=\\S+$).{8,}$");

    @Override
    public ValidationResult validate(ChangePasswordForm element, String value, ValidationContent content) {
        value = value.trim();
        var ok = regex
                .matcher(value)
                .matches();

        if (!ok){
            return ValidationResult.fail("changepassword.incorrect.password");
        }

        if (!value.equalsIgnoreCase(element.getRepeatPassword())){
            return ValidationResult.fail("passwsord_does_not_match");
        }

       return ValidationResult.PASSED;

    }
}
