package systems.dennis.auth.service;

import org.springframework.stereotype.Service;
import systems.dennis.auth.client.LoginPassword;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.entity.UserInScopeModel;
import systems.dennis.auth.repository.RolesToUserRepo;
import systems.dennis.auth.repository.UserInScopeRepo;
import systems.dennis.auth.repository.UserRoleRepo;
import systems.dennis.auth.role_validator.entity.RolesToUser;
import systems.dennis.auth.role_validator.entity.UserRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.scopes.model.ScopeModel;
import systems.dennis.shared.scopes.service.ScopeService;
import systems.dennis.shared.utils.ApplicationContext;

import java.util.List;
import java.util.Optional;

@Service
public class DataCleanupService extends ApplicationContext {

    public DataCleanupService(WebContext context) {
        super(context);
    }

    public Boolean cleanupData(String scopeName) {
        ScopeModel scope = getBean(ScopeService.class).findByName(scopeName, getCurrentUser(), true);

        cleanupRolesToUser(scope);
        cleanupUsersInScope(scope);

        return true;
    }

    private void cleanupRolesToUser(ScopeModel scope) {
        RolesToUserRepo rolesToUserRepo = getBean(RolesToUserRepo.class);

        AbstractDataFilter<UserRole> byScopeSpec = getBean(RoleServiceImpl.class).getFilterImpl().eq("scope", scope);
        List<UserRole> usersRoles = getBean(UserRoleRepo.class).filteredData(byScopeSpec).toList();

        Optional<LoginPassword> admin = getBean(LoginPasswordService.class).findUserByLogin("admin");

        for (UserRole userRole : usersRoles) {
            RoleToUserService roleToUserService = getBean(RoleToUserService.class);
            AbstractDataFilter<RolesToUser> roleSpec = getBean(RoleToUserService.class).getFilterImpl().eq("role", userRole);
            if (admin.isPresent()) {
                roleSpec.and(roleToUserService.getFilterImpl().notEq("role", userRole));
            }
            List<RolesToUser> rolesToUsers = rolesToUserRepo.filteredData(roleSpec).toList();
            rolesToUserRepo.deleteAll(rolesToUsers);
        }
    }

    private void cleanupUsersInScope(ScopeModel scope) {
        AbstractDataFilter<UserInScopeModel> specification = getBean(UserInScopeService.class).getFilterImpl().eq("scope", scope);
        Optional<UserData> admin = getBean(ProfilePageService.class).findByEmail("admin");

        if (admin.isPresent()) {
            specification.and(getBean(UserInScopeService.class).getFilterImpl().notEq("user", admin.get()));
        }

        List<UserInScopeModel> usersInScope = getBean(UserInScopeRepo.class).filteredData(specification).toList();
        getBean(UserInScopeRepo.class).deleteAll(usersInScope);
    }
}
