package systems.dennis.auth.provider;

import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.pojo_form.DataProvider;
import systems.dennis.shared.pojo_form.ItemValue;

import java.util.ArrayList;

public class UserStatusProvider implements DataProvider<Long> {
    public static final Long REGISTERED_AND_VERIFIED = 0L;
    public static final Long REGISTERED_NOT_VERIFIED = 1L;
    public static final Long NOT_REGISTERED = 2L;
    public static final Long REGISTERED_NO_VERIFICATION_REQUIRED = 3L;

    @Override
    public ArrayList<ItemValue<Long>> getItems(WebContext.LocalWebContext context) {
        var data = new ArrayList<ItemValue<Long>>();

        data.add(new ItemValue<>("REGISTERED_AND_VERIFIED", REGISTERED_AND_VERIFIED));
        data.add(new ItemValue<>("REGISTERED_NOT_VERIFIED", REGISTERED_NOT_VERIFIED));
        data.add(new ItemValue<>("NOT_REGISTERED", NOT_REGISTERED));
        data.add(new ItemValue<>("REGISTERED_NO_VERIFICATION_REQUIRED", REGISTERED_NO_VERIFICATION_REQUIRED));
        return data;
    }
}
