package systems.dennis.auth.form;

import lombok.Data;
import systems.dennis.auth.service.AuthScopeService;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.annotations.Validation;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.DEFAULT_TYPES;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.pojo_view.list.Remote;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.utils.TSDate;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;
import systems.dennis.shared.utils.bean_copier.DateToUTCConverter;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;
import systems.dennis.shared.validation.EmailValidator;
import systems.dennis.shared.validation.ValueNotEmptyValidator;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.*;

@Data
@PojoListView(actions = {"download", "new", "settings"})
public class InvitationForm implements DefaultForm {

    @PojoFormElement(type = HIDDEN)
    private Long id;

    @PojoFormElement
    @PojoListViewField(searchable = true)
    private String name;

    @PojoFormElement(required = true)
    @PojoListViewField(searchable = true)
    @Validation({ValueNotEmptyValidator.class, EmailValidator.class})
    private String email;

    @ObjectByIdPresentation
    @DataTransformer(transFormWith = IdToObjectTransformer.class, additionalClass = ProfilePageService.class)
    @PojoFormElement(type = DEFAULT_TYPES.OBJECT_SEARCH,
            remote = @Remote(fetcher = "auth/profile", searchType = DEFAULT_TYPES.OBJECT_SEARCH, searchField = "name", searchName = "profile"))
    @PojoListViewField(type = DEFAULT_TYPES.OBJECT_SEARCH, searchable = true,
            remote = @Remote(fetcher = "auth/profile", searchType = DEFAULT_TYPES.OBJECT_SEARCH, searchField = "name", searchName = "profile"))
    private Long inviter;

    @ObjectByIdPresentation
    @DataTransformer(transFormWith = IdToObjectTransformer.class, additionalClass = AuthScopeService.class)
    @PojoFormElement(type = DEFAULT_TYPES.OBJECT_SEARCH, available = false,
            remote = @Remote(fetcher = "auth/scope", searchType = DEFAULT_TYPES.OBJECT_SEARCH, searchField = "name", searchName = "scope"))
    @PojoListViewField(type = DEFAULT_TYPES.OBJECT_SEARCH, searchable = true,
            remote = @Remote(fetcher = "auth/scope", searchType = DEFAULT_TYPES.OBJECT_SEARCH, searchField = "name", searchName = "scope"))
    private Long scope;

    @PojoFormElement(available = false)
    @PojoListViewField(type = CHECKBOX, remote = @Remote(searchType = CHECKBOX))
    private Boolean accepted;

    @PojoFormElement(type = DATE)
    @PojoListViewField(searchable = true, type = DATE, remote = @Remote(searchType = DATE))
    @DataTransformer(transFormWith = DateToUTCConverter.class)
    private TSDate date;

    @PojoFormElement(type = DATE)
    @PojoListViewField(searchable = true, type = DATE, remote = @Remote(searchType = DATE))
    @DataTransformer(transFormWith = DateToUTCConverter.class)
    private TSDate dateDue;

    @PojoListViewField(actions = {@UIAction(component = "delete", allowOnMultipleRows = true)})
    @PojoFormElement(available = false)
    private Integer action;
}
