package systems.dennis.auth.form;

import lombok.Data;
import systems.dennis.auth.validators.ChangePasswordValidator;
import systems.dennis.shared.annotations.Validation;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.DEFAULT_TYPES;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.postgres.form.DefaultForm;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.HIDDEN;

@Data
public class ChangePasswordForm implements DefaultForm {

    @PojoFormElement(type = HIDDEN)
    @PojoListViewField(widthInTable = "20px")
    private Long id;


    @PojoFormElement(placeHolder = "If 2fa enabled", autocomplete = false)
    private String code;

    @Validation(CurrentPasswordValidator.class)

    @PojoFormElement(required = true, type = DEFAULT_TYPES.PASSWORD, autocomplete = false)
    private String currentPassword;

    @PojoFormElement(required = true, type = DEFAULT_TYPES.PASSWORD, validators = ChangePasswordValidator.class)
    private String password;

    @PojoFormElement(required = true, type = DEFAULT_TYPES.PASSWORD)
    private String repeatPassword;

    @PojoFormElement(type = HIDDEN)
    private Boolean twoFactor;
    @PojoFormElement(type = HIDDEN)
    private String twoFactorCode;

}
