package systems.dennis.auth.entity;

import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import lombok.Data;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.service.AuthScopeService;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.postgres.model.LongAssignableEntity;
import systems.dennis.shared.scopes.model.ScopeModel;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

@Entity
@Data
public class UserInScopeModel extends LongAssignableEntity {

    @ObjectByIdPresentation
    @ManyToOne
    @DataTransformer(additionalClass = ProfilePageService.class, transFormWith = IdToObjectTransformer.class)
    private UserData user;

    @ObjectByIdPresentation
    @ManyToOne ()
    @DataTransformer(additionalClass = AuthScopeService.class, transFormWith = IdToObjectTransformer.class)
    private ScopeModel scope;

    @Override
    public String asValue() {
        return user.getName()+ "_" + scope.getName();
    }
}
