package systems.dennis.auth.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import lombok.Data;
import systems.dennis.auth.service.AuthScopeService;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.entity.KeyValue;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.postgres.model.LongAssignableEntity;
import systems.dennis.shared.scopes.model.ScopeModel;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.IdToObjectTransformer;

import java.util.Date;

@Data
@Entity
public class ActiveToken extends LongAssignableEntity implements AbstractForm<Long> {
    public static final String DEFAULT_TOKEN_TYPE = "DEFAULT";
    public static final String DEFAULT_PHONE_TYPE = "PHONE";
    public static final String DEFAULT_LDAP_TOKEN_TYPE = "LDAP";
    public static final String DEFAULT_VIRTUAL_TYPE = "VIRTUAL";
    @Column (columnDefinition = "TEXT")
    private String token;

    private Date due;

    private Boolean active = Boolean.TRUE;
    private String type = DEFAULT_TOKEN_TYPE;

    private Date closed;

    @ObjectByIdPresentation
    @ManyToOne
    @DataTransformer(additionalClass = AuthScopeService.class, transFormWith = IdToObjectTransformer.class)
    private ScopeModel scope;

    @Override
    public String asValue() {
        return token;
    }

    @Override
    public KeyValue defaultSearchOrderField() {
        return super.defaultSearchOrderField();
    }
}
