package systems.dennis.auth.controller;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.auth.client.entity.UserData;
import systems.dennis.auth.client.entity.UserDataForm;
import systems.dennis.auth.service.ProfilePageService;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.controller.SearcherInfo;
import systems.dennis.shared.postgres.controller.DeleteItemController;
import systems.dennis.shared.postgres.controller.EditItemController;
import systems.dennis.shared.postgres.controller.ListItemController;
import systems.dennis.shared.utils.ApplicationContext;

import static systems.dennis.auth.role_validator.entity.UserRole.ROLE_ADMIN;
@RestController
@CrossOrigin("*")
@RequestMapping("/api/v2/auth/userdata")
@Secured (roles = ROLE_ADMIN)
@WebFormsSupport(ProfilePageService.class)

public class ProfileDataController extends ApplicationContext implements
        DeleteItemController<UserData>,
        EditItemController<UserData, UserDataForm>,
        ListItemController<UserData, UserDataForm> {

    static {
        SearchEntityApi.registerSearch("profile",  new SearcherInfo("email", ProfilePageService.class));
    }
    public ProfileDataController(WebContext context) {
        super(context);
    }

}
