package systems.dennis.auth.client.entity;

import lombok.Data;
import lombok.ToString;
import systems.dennis.auth.validators.EmailExistenceValidator;
import systems.dennis.auth.validators.PhoneNumberValidator;
import systems.dennis.shared.annotations.Validation;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.postgres.form.DefaultForm;
import systems.dennis.shared.validation.EmailValidator;
import systems.dennis.shared.validation.ValueNotEmptyValidator;

import static systems.dennis.shared.pojo_view.DEFAULT_TYPES.*;

@Data
@ToString
@PojoListView (actions = {"download",   "settings"})
public class UserDataForm implements DefaultForm {

    @PojoFormElement(type = HIDDEN)
    private Long id;

    @PojoFormElement(type = HIDDEN)
    @PojoListViewField (searchable = true)
    private String login;


    @PojoFormElement(type = HIDDEN)
    @PojoListViewField (searchable = true)
    @Validation ({EmailValidator.class, EmailExistenceValidator.class})
    private String email;

    @Validation (ValueNotEmptyValidator.class)
    @PojoFormElement(required = true)
    @PojoListViewField (searchable = true)
    private String name;

    @Validation({PhoneNumberValidator.class, ValueNotEmptyValidator.class})
    @PojoFormElement( required = true)
    @PojoListViewField (searchable = true)
    private String phone;

    @PojoFormElement(type = FILE)
    @PojoListViewField (type = FILE)
    private String imagePath;

    @PojoFormElement(type = TEXT)
    @PojoListViewField (searchable = true)
    private String address;

    private Boolean hiddenBySystem;


    @PojoListViewField(showContent = false, actions = {
            @UIAction(component = "edit")
    })
    private int actions;

    @Override
    public String asValue() {
        return email;
    }
}
