package systems.dennis.auth;

import org.aspectj.lang.annotation.Aspect;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.client.RestTemplate;
import systems.dennis.shared.config.MessageResourceSource;
import systems.dennis.shared.config.WebContext;
import systems.dennis.auth.client.utils.BasicAuthAoe;
import systems.dennis.auth.client.required.TokenValidator;
import systems.dennis.shared.postgres.repository.PaginationRepositoryImpl;

@SpringBootApplication(scanBasePackages = {"systems.dennis.shared*", "systems.dennis.auth"})
@EntityScan({"systems.dennis.*"})
@EnableJpaRepositories(value = {"systems.dennis.*"}, repositoryBaseClass = PaginationRepositoryImpl.class)
@CrossOrigin
public class AuthApp {

    public AuthApp(MessageResourceSource resourceSource) {
        this.resourceSource = resourceSource;
    }

    public static void main(String[] args) {
        SpringApplication.run(AuthApp.class);

    }

    private final MessageResourceSource resourceSource;
    @Bean @Primary
    public MessageSource messageSource() {
        resourceSource.setBasename("messages");
        resourceSource.setDefaultEncoding("UTF-8");
        return resourceSource;
    }
    @Aspect
    @Component
    public class aop extends BasicAuthAoe {

        public aop(TokenValidator tokenValidator, WebContext context) {
            super(tokenValidator, context);
        }

    }




    @Bean
    WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> enableDefaultServlet() {
        return (factory) -> factory.setRegisterDefaultServlet(true);
    }
    @Bean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }


}
