/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.auth_client.client;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import systems.dennis.shared.auth_client.exception.ScopeException;
import systems.dennis.shared.auth_client.exception.TokenExpiredException;
import systems.dennis.shared.auth_client.form.UserData;
import systems.dennis.shared.auth_client.form.UserTokenDTO;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.TokenData;
import systems.dennis.shared.utils.ApplicationContext;

@Service
public class TokenProviderClient
extends ApplicationContext {
    private static final Logger log = LoggerFactory.getLogger(TokenProviderClient.class);
    public static final String AUTHORITIES_KEY = "groups";
    public static final String USER_ID = "user_id";
    public static final String USER_EMAIL = "email";
    public static final String USER_LOGIN = "bid";
    public static final String USER_INNER_NUMBER = "userDataId";
    public static final String ISSUER = "usb";
    public static final String PURCHASES = "prchs";
    public static final String LANG = "lang";

    public TokenProviderClient(WebContext context) {
        super(context);
    }

    public UserTokenDTO validateToken(TokenData token) {
        UserTokenDTO dto = new UserTokenDTO();
        dto.setToken(token.getToken());
        dto.setScope(token.getScope());
        return this.validateToken(dto);
    }

    public UserTokenDTO validateToken(UserTokenDTO dto) {
        try {
            Jws claimsJws = Jwts.parser().setSigningKey(this.getSecretKey(dto.getScope()).getBytes()).build().parseSignedClaims((CharSequence)dto.getToken().replace("Bearer ", ""));
            Date due = ((Claims)claimsJws.getPayload()).getExpiration();
            dto.setScope((String)((Claims)claimsJws.getBody()).get("scope", String.class));
            if (due.getTime() < new Date().getTime()) {
                throw new TokenExpiredException(dto.getToken());
            }
            dto.setDue(due);
            return dto;
        }
        catch (MalformedJwtException | SecurityException e) {
            log.info("Invalid JWT signature.");
            log.trace("Invalid JWT signature trace: {0}", e);
        }
        catch (ExpiredJwtException e) {
            log.info("Expired JWT token.");
            log.trace("Expired JWT token trace: {0}", (Throwable)e);
        }
        catch (UnsupportedJwtException e) {
            log.info("Unsupported JWT token.");
            log.trace("Unsupported JWT token trace: {0}", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.info("JWT token compact of handler are invalid.");
            log.trace("JWT token compact of handler are invalid trace: {0}", (Throwable)e);
        }
        return null;
    }

    public UserTokenDTO getAuthentication(TokenData tokenData) {
        String token = tokenData.getToken();
        if (token == null || token.trim().isEmpty() || token.equals("null")) {
            return null;
        }
        Claims claims = (Claims)Jwts.parser().setSigningKey(this.getSecretKey(tokenData.getScope()).getBytes()).build().parseSignedClaims((CharSequence)token).getPayload();
        UserTokenDTO dto = new UserTokenDTO();
        dto.setDue(claims.getExpiration());
        dto.setRoleListFromGD((List)claims.get((Object)AUTHORITIES_KEY));
        dto.setToken(token);
        dto.setScope((String)claims.get("s", String.class));
        dto.setScope(dto.getScope());
        UserData userData = new UserData();
        userData.setLogin(claims.getSubject());
        userData.setId(Long.valueOf(String.valueOf(claims.get((Object)USER_ID))));
        userData.setEmail(String.valueOf(claims.get((Object)USER_EMAIL)));
        userData.setLogin(String.valueOf(claims.get((Object)USER_LOGIN)));
        userData.setPurchases((List)claims.get((Object)PURCHASES));
        dto.setUserData(userData);
        return dto;
    }

    public String getSecretKey(String scope) {
        try {
            Object res = this.getContext().getEnv("dennis.systems.security.secret_" + scope);
            if (res == null) {
                throw new RuntimeException();
            }
            return String.valueOf(res);
        }
        catch (Exception e) {
            throw new ScopeException("global.scope.not_supported");
        }
    }
}

