package systems.dennis.shared.auth_client.controller;

import lombok.Data;
import systems.dennis.shared.auth_client.form.UserTokenDTO;

import java.util.Date;

@Data
public class AuthorizeResponse {
    UserTokenDTO dto;
    boolean success;
    Date date = new Date();
    boolean withOldToken;

    public static AuthorizeResponse of(UserTokenDTO dto, boolean oldToken) {
        AuthorizeResponse response = new AuthorizeResponse();
        response.setDto(dto);
        response.setSuccess(true);
        return response;
    }
}
