/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.auth_client;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.security.ISecurityUtils;
import systems.dennis.shared.auth_client.client.TokenProviderClient;
import systems.dennis.shared.auth_client.form.UserTokenDTO;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.entity.TokenData;
import systems.dennis.shared.exceptions.AuthorizationNotFoundException;
import systems.dennis.shared.model.AbstractUserAssignableElement;
import systems.dennis.shared.utils.ApplicationContext;

@Service
@Primary
public class SecurityUtils<T extends Serializable>
extends ApplicationContext
implements ISecurityUtils<T> {
    private HttpServletRequest request;
    public static final String AUTHORIZATION_HEADER = "Authorization";
    String AUTH_TYPE_HEADER = "AUTH_TYPE";
    String AUTH_SCOPE_HEADER = "AUTH_SCOPE";

    public SecurityUtils(WebContext context, HttpServletRequest request) {
        super(context);
        this.request = request;
    }

    public T getUserDataId() {
        return (T)this.tokenFromHeader().getUserData().getId();
    }

    public UserTokenDTO tokenFromHeader() throws AuthorizationNotFoundException {
        return ((TokenProviderClient)((Object)this.getBean(TokenProviderClient.class))).getAuthentication(this.getToken());
    }

    public TokenData getToken() {
        if (this.request == null) {
            return null;
        }
        String token = this.request.getHeader(AUTHORIZATION_HEADER);
        String tokenScope = this.request.getHeader(this.AUTH_SCOPE_HEADER);
        if (token == null) {
            throw new AuthorizationNotFoundException("Expected token, instead no token");
        }
        token = token.replace("Bearer ", "").trim();
        return new TokenData(tokenScope, token);
    }

    public void assignUser(AbstractEntity<T> pojo) {
        pojo.setId(this.getCurrentUser());
    }

    public void assignUser(AbstractEntity<T> pojo, AbstractEntity<T> pojoOriginal) {
        if (pojo instanceof AbstractUserAssignableElement) {
            ((AbstractUserAssignableElement)pojo).setUserDataId(((AbstractUserAssignableElement)pojoOriginal).getUserDataId());
        }
    }

    public boolean isAdmin() {
        return this.hasRole("ROLE_ADMIN");
    }

    public boolean hasRole(String role) {
        return this.tokenFromHeader().getRoleList().contains(role);
    }

    public String getUserLanguage() {
        return this.tokenFromHeader().getUserData().getPreferredLanguage();
    }

    public UserTokenDTO get() {
        return this.tokenFromHeader();
    }
}

