package systems.dennis.shared.auth_client.form;

import jakarta.persistence.Transient;
import lombok.Data;
import lombok.ToString;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.DateAndStringConverter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
@ToString
public class UserData  {


    public static final  String USER_ID_FIELD = "userDataId";

    private String login;
    private Serializable id;
    private String email;
    private String name;
    private String phone;
    private String address;

    @FormTransient
    @DataTransformer(transFormWith = DateAndStringConverter.class, params = "HH:mm:ss dd.MM.yyyy")
    private Date lastUpdate = new Date();
    private String imagePath;
    private String preferredLanguage = "en";

    private Boolean blocked = Boolean.FALSE;
    private String telegramName;

    @Transient
    private List<String> purchases;

    @FormTransient
    private Boolean verified;

    public UserData(){}

    public UserData(String login){
        this.login = login;
    }

}
