package systems.dennis.shared.auth_client.client;


import org.springframework.http.ResponseEntity;
import systems.dennis.shared.annotations.NeverNullResponse;
import systems.dennis.shared.utils.Supplier;

public interface AbstractServerRequest <T> {
    @NeverNullResponse
    public AbstractServerRequest<T> virtualAuth();

    @NeverNullResponse
    public AbstractServerRequest<T> uri(String uri);

    @NeverNullResponse
    public AbstractServerRequest<T> server(Long type);

    @NeverNullResponse
    public AbstractServerRequest<T> token(String token);

    @NeverNullResponse
    public AbstractServerRequest<T> scope();

    @NeverNullResponse
    public AbstractServerRequest<T> onErrorStatusError(int status, Supplier<?> e);

    @NeverNullResponse
    public AbstractServerRequest<T> onAnyErrorStatusError(Supplier<?> e);


    /**
     * @deprecated as normally default type doesn't require this header
     */
    @Deprecated
    @NeverNullResponse
    public AbstractServerRequest<T> defaultAuthType();


    public <E> T executePost(E object, Class<T> tClass);

    void validateExceptions(ResponseEntity<T> resp);

    public <E> T executeGet(Class<T> tClass);

    public void executeDelete(Class<T> tClass);

    String getCurrentScope();


}
