/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.auth_client.form;

import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import systems.dennis.shared.auth_client.exception.TokenExpiredException;
import systems.dennis.shared.auth_client.form.UserData;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.utils.OrEmpty;
import systems.dennis.shared.utils.security.AbstractAuthorizationProvider;

public class UserTokenDTO
implements AbstractAuthorizationProvider,
Serializable {
    private UserData userData;
    private static final UserData NULL = new UserData();
    private String token;
    private Long due;
    private String scope;
    private List<String> roleList;

    public void setDue(Date due) {
        this.due = due.getTime();
    }

    public void setRoleList(List<String> values) {
        if (this.roleList == null && values != null) {
            this.roleList = new ArrayList<String>(values.size());
        }
        if (values == null) {
            return;
        }
        this.roleList.addAll(values);
    }

    @Transient
    public void setRoleListFromGD(List<String> values) {
        if (this.roleList == null) {
            this.roleList = new ArrayList<String>(values.size());
        }
        for (String string : values) {
            this.roleList.add(string);
        }
    }

    public boolean validate(WebContext.LocalWebContext context) throws TokenExpiredException {
        if (this.getDue() == null || this.getDue() < new Date().getTime()) {
            throw new TokenExpiredException(this.token);
        }
        return true;
    }

    public void setRoles(List<String> roles) {
        this.roleList = roles;
    }

    public String getLogin() {
        return this.userData.getLogin();
    }

    public String getPassword() {
        return "HIDDEN";
    }

    public Serializable getUserId() {
        return ((UserData)OrEmpty.valueOrDef((Object)this.getUserData(), (Object)NULL)).getId();
    }

    public static UserTokenDTOBuilder builder() {
        return new UserTokenDTOBuilder();
    }

    public UserTokenDTOBuilder toBuilder() {
        return new UserTokenDTOBuilder().userData(this.userData).token(this.token).due(this.due).scope(this.scope).roleList(this.roleList);
    }

    public UserData getUserData() {
        return this.userData;
    }

    public String getToken() {
        return this.token;
    }

    public Long getDue() {
        return this.due;
    }

    public String getScope() {
        return this.scope;
    }

    public List<String> getRoleList() {
        return this.roleList;
    }

    public void setUserData(UserData userData) {
        this.userData = userData;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserTokenDTO)) {
            return false;
        }
        UserTokenDTO other = (UserTokenDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$due = this.getDue();
        Long other$due = other.getDue();
        if (this$due == null ? other$due != null : !((Object)this$due).equals(other$due)) {
            return false;
        }
        UserData this$userData = this.getUserData();
        UserData other$userData = other.getUserData();
        if (this$userData == null ? other$userData != null : !((Object)this$userData).equals(other$userData)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        List<String> this$roleList = this.getRoleList();
        List<String> other$roleList = other.getRoleList();
        return !(this$roleList == null ? other$roleList != null : !((Object)this$roleList).equals(other$roleList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserTokenDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $due = this.getDue();
        result = result * 59 + ($due == null ? 43 : ((Object)$due).hashCode());
        UserData $userData = this.getUserData();
        result = result * 59 + ($userData == null ? 43 : ((Object)$userData).hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        List<String> $roleList = this.getRoleList();
        result = result * 59 + ($roleList == null ? 43 : ((Object)$roleList).hashCode());
        return result;
    }

    public String toString() {
        return "UserTokenDTO(userData=" + String.valueOf(this.getUserData()) + ", token=" + this.getToken() + ", due=" + this.getDue() + ", scope=" + this.getScope() + ", roleList=" + String.valueOf(this.getRoleList()) + ")";
    }

    public UserTokenDTO(UserData userData, String token, Long due, String scope, List<String> roleList) {
        this.userData = userData;
        this.token = token;
        this.due = due;
        this.scope = scope;
        this.roleList = roleList;
    }

    public UserTokenDTO() {
    }

    public static class UserTokenDTOBuilder {
        private UserData userData;
        private String token;
        private Long due;
        private String scope;
        private List<String> roleList;

        UserTokenDTOBuilder() {
        }

        public UserTokenDTOBuilder userData(UserData userData) {
            this.userData = userData;
            return this;
        }

        public UserTokenDTOBuilder token(String token) {
            this.token = token;
            return this;
        }

        public UserTokenDTOBuilder due(Long due) {
            this.due = due;
            return this;
        }

        public UserTokenDTOBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public UserTokenDTOBuilder roleList(List<String> roleList) {
            this.roleList = roleList;
            return this;
        }

        public UserTokenDTO build() {
            return new UserTokenDTO(this.userData, this.token, this.due, this.scope, this.roleList);
        }

        public String toString() {
            return "UserTokenDTO.UserTokenDTOBuilder(userData=" + String.valueOf(this.userData) + ", token=" + this.token + ", due=" + this.due + ", scope=" + this.scope + ", roleList=" + String.valueOf(this.roleList) + ")";
        }
    }
}

