/*
 * Decompiled with CFR 0.152.
 */
package systems.crigges.jmpq3;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import systems.crigges.jmpq3.BlockTable;
import systems.crigges.jmpq3.HashTable;
import systems.crigges.jmpq3.JMpqException;
import systems.crigges.jmpq3.Listfile;
import systems.crigges.jmpq3.MpqFile;

public class JMpqEditor
implements AutoCloseable {
    private FileChannel fc;
    private File mpqFile;
    private int headerOffset = -1;
    private int headerSize;
    private int archiveSize;
    private int formatVersion;
    private int discBlockSize;
    private int hashPos;
    private int blockPos;
    private int hashSize;
    private int blockSize;
    private HashTable hashTable;
    private BlockTable blockTable;
    private Listfile listFile;
    private HashMap<File, String> internalFilename = new HashMap();
    private ArrayList<File> filesToAdd = new ArrayList();
    private boolean keepHeaderOffset = true;
    private int newHeaderSize;
    private int newArchiveSize;
    private int newFormatVersion;
    private int newDiscBlockSize;
    private int newHashPos;
    private int newBlockPos;
    private int newHashSize;
    private int newBlockSize;

    public JMpqEditor(File mpqW) throws JMpqException {
        this.mpqFile = mpqW;
        try {
            File tempMpq = File.createTempFile("work", "around");
            tempMpq.deleteOnExit();
            Files.copy(mpqW.toPath(), tempMpq.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.fc = FileChannel.open(tempMpq.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
            this.headerOffset = this.searchHeader();
            MappedByteBuffer temp = this.fc.map(FileChannel.MapMode.READ_ONLY, this.headerOffset + 4, 4L);
            temp.order(ByteOrder.LITTLE_ENDIAN);
            this.headerSize = temp.getInt();
            MappedByteBuffer headerBuffer = this.fc.map(FileChannel.MapMode.READ_ONLY, this.headerOffset + 8, this.headerSize);
            headerBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.readHeader(headerBuffer);
            MappedByteBuffer hashBuffer = this.fc.map(FileChannel.MapMode.READ_ONLY, this.hashPos + this.headerOffset, this.hashSize * 16);
            hashBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.hashTable = new HashTable(hashBuffer);
            MappedByteBuffer blockBuffer = this.fc.map(FileChannel.MapMode.READ_ONLY, this.blockPos + this.headerOffset, this.blockSize * 16);
            blockBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.blockTable = new BlockTable(blockBuffer);
            if (this.hasFile("(listfile)")) {
                try {
                    File tempFile = File.createTempFile("list", "file");
                    this.extractFile("(listfile)", tempFile);
                    this.listFile = new Listfile(Files.readAllBytes(tempFile.toPath()));
                }
                catch (IOException e) {
                    this.listFile = null;
                }
            }
        }
        catch (IOException e) {
            throw new JMpqException(e);
        }
    }

    private int searchHeader() throws JMpqException {
        try {
            MappedByteBuffer buffer = this.fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.fc.size() / 512L * 512L);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int i = 0;
            while ((long)i < this.fc.size() / 512L) {
                buffer.position(i * 512);
                byte[] start = new byte[3];
                buffer.get(start);
                String s = new String(start);
                if (s.equals("MPQ")) {
                    return buffer.position() - 3;
                }
                ++i;
            }
            throw new JMpqException("The given file is not a mpq or damaged");
        }
        catch (IOException e) {
            throw new JMpqException(e);
        }
    }

    private void readHeader(MappedByteBuffer buffer) {
        this.archiveSize = buffer.getInt();
        this.formatVersion = buffer.getShort();
        this.discBlockSize = 512 * (1 << buffer.getShort());
        this.hashPos = buffer.getInt();
        this.blockPos = buffer.getInt();
        this.hashSize = buffer.getInt();
        this.blockSize = buffer.getInt();
    }

    private void writeHeader(MappedByteBuffer buffer) {
        buffer.putInt(this.newHeaderSize);
        buffer.putInt(this.newArchiveSize);
        buffer.putShort((short)this.newFormatVersion);
        buffer.putShort((short)3);
        buffer.putInt(this.newHashPos);
        buffer.putInt(this.newBlockPos);
        buffer.putInt(this.newHashSize);
        buffer.putInt(this.newBlockSize);
    }

    private void calcNewTableSize() {
        int current;
        int target = this.listFile.getFiles().size() + 1;
        for (current = 2; current < target; current *= 2) {
        }
        this.newHashSize = current;
        this.newBlockSize = this.listFile.getFiles().size() + 1;
    }

    public void printHeader() {
        System.out.println("Header offset: " + this.headerOffset);
        System.out.println("Archive size: " + this.archiveSize);
        System.out.println("Format version: " + this.formatVersion);
        System.out.println("Disc block size: " + this.discBlockSize);
        System.out.println("Hashtable position: " + this.hashPos);
        System.out.println("Blocktable position: " + this.blockPos);
        System.out.println("Hashtable size: " + this.hashSize);
        System.out.println("Blocktable size: " + this.blockSize);
    }

    public void extractAllFiles(File dest) throws JMpqException {
        if (!dest.isDirectory()) {
            throw new JMpqException("Destination location isn't a directory");
        }
        if (this.listFile != null) {
            for (String s : this.listFile.getFiles()) {
                File temp = new File(dest.getAbsolutePath() + "\\" + s);
                temp.getParentFile().mkdirs();
                this.extractFile(s, temp);
            }
        } else {
            ArrayList<BlockTable.Block> blocks = this.blockTable.getAllVaildBlocks();
            try {
                int i = 0;
                for (BlockTable.Block b : blocks) {
                    if ((b.getFlags() & 0x10000) == 65536) continue;
                    MappedByteBuffer buf = this.fc.map(FileChannel.MapMode.READ_ONLY, this.headerOffset, this.fc.size() - (long)this.headerOffset);
                    buf.order(ByteOrder.LITTLE_ENDIAN);
                    MpqFile f = new MpqFile(buf, b, this.discBlockSize, "");
                    f.extractToFile(new File(dest.getAbsolutePath() + "\\" + i));
                    ++i;
                }
            }
            catch (IOException e) {
                throw new JMpqException(e);
            }
        }
    }

    public int getTotalFileCount() throws JMpqException {
        return this.blockTable.getAllVaildBlocks().size();
    }

    public void extractFile(String name, File dest) throws JMpqException {
        try {
            int pos = this.hashTable.getBlockIndexOfFile(name);
            BlockTable.Block b = this.blockTable.getBlockAtPos(pos);
            MappedByteBuffer buf = this.fc.map(FileChannel.MapMode.READ_ONLY, this.headerOffset, this.fc.size() - (long)this.headerOffset);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            MpqFile f = new MpqFile(buf, b, this.discBlockSize, name);
            f.extractToFile(dest);
        }
        catch (IOException e) {
            throw new JMpqException(e);
        }
    }

    public boolean hasFile(String name) {
        try {
            this.hashTable.getBlockIndexOfFile(name);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public List<String> getFileNames() {
        return (List)this.listFile.getFiles().clone();
    }

    public void extractFile(String name, OutputStream dest) throws JMpqException {
        try {
            int pos = this.hashTable.getBlockIndexOfFile(name);
            BlockTable.Block b = this.blockTable.getBlockAtPos(pos);
            MappedByteBuffer buf = this.fc.map(FileChannel.MapMode.READ_ONLY, this.headerOffset, this.fc.size() - (long)this.headerOffset);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            MpqFile f = new MpqFile(buf, b, this.discBlockSize, name);
            f.extractToOutputStream(dest);
        }
        catch (IOException e) {
            throw new JMpqException(e);
        }
    }

    public MpqFile getMpqFile(String name) throws IOException {
        int pos = this.hashTable.getBlockIndexOfFile(name);
        BlockTable.Block b = this.blockTable.getBlockAtPos(pos);
        MappedByteBuffer buf = this.fc.map(FileChannel.MapMode.READ_ONLY, this.headerOffset, this.fc.size() - (long)this.headerOffset);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        return new MpqFile(buf, b, this.discBlockSize, name);
    }

    public void deleteFile(String name) throws JMpqException {
        this.listFile.removeFile(name);
    }

    public void insertFile(String name, File f, boolean backupFile) throws JMpqException {
        try {
            this.listFile.addFile(name);
            if (backupFile) {
                File temp = File.createTempFile("wurst", "crig");
                Files.copy(f.toPath(), temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.filesToAdd.add(temp);
                this.internalFilename.put(temp, name);
            } else {
                this.filesToAdd.add(f);
                this.internalFilename.put(f, name);
            }
        }
        catch (IOException e) {
            throw new JMpqException(e);
        }
    }

    @Override
    public void close() throws IOException {
        File temp = File.createTempFile("crig", "mpq");
        FileChannel writeChannel = FileChannel.open(temp.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ);
        if (this.keepHeaderOffset) {
            MappedByteBuffer headerReader = this.fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.headerOffset + 4);
            writeChannel.write(headerReader);
        }
        this.newHeaderSize = this.headerSize;
        this.newFormatVersion = this.formatVersion;
        this.newDiscBlockSize = this.discBlockSize;
        this.calcNewTableSize();
        ArrayList<BlockTable.Block> newBlocks = new ArrayList<BlockTable.Block>();
        ArrayList<String> newFiles = new ArrayList<String>();
        LinkedList remainingFiles = (LinkedList)this.listFile.getFiles().clone();
        int currentPos = this.headerOffset + this.headerSize;
        for (File f : this.filesToAdd) {
            newFiles.add(this.internalFilename.get(f));
            remainingFiles.remove(this.internalFilename.get(f));
            MappedByteBuffer fileWriter = writeChannel.map(FileChannel.MapMode.READ_WRITE, currentPos, f.length() * 2L);
            BlockTable.Block newBlock = new BlockTable.Block(currentPos - this.headerOffset, 0, 0, 0);
            newBlocks.add(newBlock);
            MpqFile.writeFileAndBlock(f, newBlock, fileWriter, this.newDiscBlockSize);
            currentPos += newBlock.getCompressedSize();
        }
        for (String s : remainingFiles) {
            newFiles.add(s);
            int pos = this.hashTable.getBlockIndexOfFile(s);
            BlockTable.Block b = this.blockTable.getBlockAtPos(pos);
            MappedByteBuffer buf = this.fc.map(FileChannel.MapMode.READ_ONLY, this.headerOffset, this.fc.size() - (long)this.headerOffset);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            MpqFile f = new MpqFile(buf, b, this.discBlockSize, s);
            MappedByteBuffer fileWriter = writeChannel.map(FileChannel.MapMode.READ_WRITE, currentPos, b.getCompressedSize());
            BlockTable.Block newBlock = new BlockTable.Block(currentPos - this.headerOffset, 0, 0, 0);
            newBlocks.add(newBlock);
            f.writeFileAndBlock(newBlock, fileWriter);
            currentPos += b.getCompressedSize();
        }
        newFiles.add("(listfile)");
        byte[] listfileArr = this.listFile.asByteArray();
        MappedByteBuffer fileWriter = writeChannel.map(FileChannel.MapMode.READ_WRITE, currentPos, listfileArr.length);
        BlockTable.Block newBlock = new BlockTable.Block(currentPos - this.headerOffset, 0, 0, 0);
        newBlocks.add(newBlock);
        MpqFile.writeFileAndBlock(listfileArr, newBlock, fileWriter, this.newDiscBlockSize);
        this.newHashPos = (currentPos += newBlock.getCompressedSize()) - this.headerOffset;
        this.newBlockPos = this.newHashPos + this.newHashSize * 16;
        MappedByteBuffer hashtableWriter = writeChannel.map(FileChannel.MapMode.READ_WRITE, currentPos, this.newHashSize * 16);
        hashtableWriter.order(ByteOrder.LITTLE_ENDIAN);
        HashTable.writeNewHashTable(this.newHashSize, newFiles, hashtableWriter);
        MappedByteBuffer blocktableWriter = writeChannel.map(FileChannel.MapMode.READ_WRITE, currentPos += this.newHashSize * 16, this.newBlockSize * 16);
        blocktableWriter.order(ByteOrder.LITTLE_ENDIAN);
        BlockTable.writeNewBlocktable(newBlocks, this.newBlockSize, blocktableWriter);
        this.newArchiveSize = (currentPos += this.newBlockSize * 16) + 1 - this.headerOffset;
        MappedByteBuffer headerWriter = writeChannel.map(FileChannel.MapMode.READ_WRITE, this.headerOffset + 4, this.headerSize + 4);
        headerWriter.order(ByteOrder.LITTLE_ENDIAN);
        this.writeHeader(headerWriter);
        MappedByteBuffer tempReader = writeChannel.map(FileChannel.MapMode.READ_WRITE, 0L, currentPos + 1);
        tempReader.position(0);
        FileChannel mpqChannel = FileChannel.open(this.mpqFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        mpqChannel.truncate(currentPos + 1);
        MappedByteBuffer tempWriter = mpqChannel.map(FileChannel.MapMode.READ_WRITE, 0L, currentPos + 1);
        tempWriter.position(0);
        tempWriter.put(tempReader);
        this.fc.close();
        writeChannel.close();
    }

    public String toString() {
        return "JMpqEditor [headerSize=" + this.headerSize + ", archiveSize=" + this.archiveSize + ", formatVersion=" + this.formatVersion + ", discBlockSize=" + this.discBlockSize + ", hashPos=" + this.hashPos + ", blockPos=" + this.blockPos + ", hashSize=" + this.hashSize + ", blockSize=" + this.blockSize + ", hashMap=" + this.hashTable + "]";
    }
}

