/*
 * Decompiled with CFR 0.152.
 */
package systems.crigges.jmpq3;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class MpqCrypto {
    public static final int MPQ_HASH_TABLE_INDEX = 0;
    public static final int MPQ_HASH_NAME_A = 1;
    public static final int MPQ_HASH_NAME_B = 2;
    public static final int MPQ_HASH_FILE_KEY = 3;
    public static final int MPQ_HASH_KEY2_MIX = 4;
    public static final int MPQ_KEY_HASH_TABLE = -1011927184;
    public static final int MPQ_KEY_BLOCK_TABLE = -326913117;
    int[] cryptTable = new int[1280];

    public MpqCrypto() {
        this.prepareCryptTable();
    }

    void prepareCryptTable() {
        int seed = 0x100001;
        int index1 = 0;
        int index2 = 0;
        for (index1 = 0; index1 < 256; ++index1) {
            index2 = index1;
            int i = 0;
            while (i < 5) {
                seed = (seed * 125 + 3) % 0x2AAAAB;
                int temp1 = (seed & 0xFFFF) << 16;
                seed = (seed * 125 + 3) % 0x2AAAAB;
                int temp2 = seed & 0xFFFF;
                this.cryptTable[index2] = temp1 | temp2;
                ++i;
                index2 += 256;
            }
        }
    }

    public int hash(String fileName, int hashType) {
        int seed1 = 2146271213;
        int seed2 = -286331154;
        for (int i = 0; i < fileName.length(); ++i) {
            char ch = Character.toUpperCase(fileName.charAt(i));
            seed1 = this.cryptTable[(hashType << 8) + ch] ^ seed1 + seed2;
            seed2 = ch + seed1 + seed2 + (seed2 << 5) + 3;
        }
        return seed1;
    }

    public byte[] decryptBlock(byte[] block, int key) {
        ByteBuffer buf = ByteBuffer.wrap(block).order(ByteOrder.LITTLE_ENDIAN);
        return this.decryptBlock(buf, block.length, key);
    }

    public byte[] decryptBlock(ByteBuffer buf, int length, int key) {
        int seed = -286331154;
        ByteBuffer resultBuffer = ByteBuffer.allocate(length).order(ByteOrder.LITTLE_ENDIAN);
        length >>= 2;
        for (int i = 0; i < length; ++i) {
            int ch = buf.getInt() ^ key + (seed += this.cryptTable[1024 + (key & 0xFF)]);
            resultBuffer.putInt(ch);
            key = (~key << 21) + 0x11111111 | key >>> 11;
            seed = ch + seed + (seed << 5) + 3;
        }
        return resultBuffer.array();
    }

    public byte[] encryptMpqBlock(ByteBuffer buf, int length, int dwKey1) {
        ByteBuffer resultBuffer = ByteBuffer.allocate(length).order(ByteOrder.LITTLE_ENDIAN);
        int dwKey2 = -286331154;
        length >>= 2;
        for (int i = 0; i < length; ++i) {
            int dwValue32 = buf.getInt();
            resultBuffer.putInt(dwValue32 ^ dwKey1 + (dwKey2 += this.cryptTable[1024 + (dwKey1 & 0xFF)]));
            dwKey1 = (~dwKey1 << 21) + 0x11111111 | dwKey1 >>> 11;
            dwKey2 = dwValue32 + dwKey2 + (dwKey2 << 5) + 3;
        }
        return resultBuffer.array();
    }

    public static void main(String[] args) {
        MpqCrypto c = new MpqCrypto();
        byte[] bytes = "Hello World!".getBytes();
        byte[] a = c.encryptMpqBlock(ByteBuffer.wrap(bytes), bytes.length, -1011927184);
        byte[] b = c.decryptBlock(ByteBuffer.wrap(a), bytes.length, -1011927184);
        System.out.println("orig = " + Arrays.toString(bytes));
        System.out.println("a = " + Arrays.toString(a));
        System.out.println("b = " + Arrays.toString(b));
        System.out.println("b = " + new String(b));
    }

    public byte[] encryptMpqBlock(byte[] bytes, int length, int key) {
        return this.encryptMpqBlock(ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN), length, key);
    }
}

