/*
 * Decompiled with CFR 0.152.
 */
package systems.composable.dropwizard.cassandra;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.datastax.driver.core.Cluster;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class CassandraMetricSet
implements MetricSet {
    private Map<String, Metric> metrics;

    public CassandraMetricSet(Cluster cluster) {
        String clusterName = cluster.getClusterName();
        Map driverMetrics = cluster.getMetrics().getRegistry().getMetrics();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        driverMetrics.forEach((k, v) -> builder.put((Object)MetricRegistry.name(Cluster.class, (String[])new String[]{clusterName, k}), v));
        this.metrics = builder.build();
    }

    public Map<String, Metric> getMetrics() {
        return this.metrics;
    }
}

