/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.core;

import java.text.MessageFormat;

public final class ArithmeticUtils {
    private ArithmeticUtils() {
    }

    public static int gcd(int p, int q) {
        int a = p;
        int b = q;
        if (a == 0 || b == 0) {
            if (a == Integer.MIN_VALUE || b == Integer.MIN_VALUE) {
                throw new NumbersArithmeticException("overflow: gcd({0}, {1}) is 2^31", p, q);
            }
            return Math.abs(a + b);
        }
        long al = a;
        long bl = b;
        boolean useLong = false;
        if (a < 0) {
            if (Integer.MIN_VALUE == a) {
                useLong = true;
            } else {
                a = -a;
            }
            al = -al;
        }
        if (b < 0) {
            if (Integer.MIN_VALUE == b) {
                useLong = true;
            } else {
                b = -b;
            }
            bl = -bl;
        }
        if (useLong) {
            if (al == bl) {
                throw new NumbersArithmeticException("overflow: gcd({0}, {1}) is 2^31", p, q);
            }
            long blbu = bl;
            bl = al;
            if ((al = blbu % al) == 0L) {
                if (bl > Integer.MAX_VALUE) {
                    throw new NumbersArithmeticException("overflow: gcd({0}, {1}) is 2^31", p, q);
                }
                return (int)bl;
            }
            blbu = bl;
            b = (int)al;
            a = (int)(blbu % al);
        }
        return ArithmeticUtils.gcdPositive(a, b);
    }

    private static int gcdPositive(int a, int b) {
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        int aTwos = Integer.numberOfTrailingZeros(a);
        a >>= aTwos;
        int bTwos = Integer.numberOfTrailingZeros(b);
        b >>= bTwos;
        int shift = Math.min(aTwos, bTwos);
        while (a != b) {
            int delta = a - b;
            b = Math.min(a, b);
            a = Math.abs(delta);
            a >>= Integer.numberOfTrailingZeros(a);
        }
        return a << shift;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long mulAndCheck(long a, long b) {
        if (a > b) {
            return ArithmeticUtils.mulAndCheck(b, a);
        }
        if (a < 0L) {
            if (b < 0L) {
                if (a < Long.MAX_VALUE / b) throw new NumbersArithmeticException();
                return a * b;
            }
            if (b <= 0L) return 0L;
            if (Long.MIN_VALUE / b > a) throw new NumbersArithmeticException();
            return a * b;
        }
        if (a <= 0L) return 0L;
        if (a > Long.MAX_VALUE / b) throw new NumbersArithmeticException();
        return a * b;
    }

    private static class NumbersArithmeticException
    extends ArithmeticException {
        private static final long serialVersionUID = 20180130L;
        private final Object[] formatArguments;

        NumbersArithmeticException() {
            this("arithmetic exception", new Object[0]);
        }

        NumbersArithmeticException(String message, Object ... args) {
            super(message);
            this.formatArguments = args;
        }

        @Override
        public String getMessage() {
            return MessageFormat.format(super.getMessage(), this.formatArguments);
        }
    }
}

