/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.shamir;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import systems.comodal.shamir.Shamir;

public final class ShamirSharesBuilder {
    private Random secureRandom;
    private BigInteger prime;
    private int numShares;
    private BigInteger[] secrets;

    ShamirSharesBuilder() {
    }

    public BigInteger getPrime() {
        return this.prime;
    }

    public int getNumShares() {
        return this.numShares;
    }

    public int getNumRequiredShares() {
        return this.secrets == null ? 0 : this.secrets.length;
    }

    public BigInteger getSecret() {
        return this.secrets == null || this.secrets.length == 0 ? null : this.secrets[0];
    }

    public ShamirSharesBuilder secureRandom(Random secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    public ShamirSharesBuilder prime(BigInteger prime) {
        this.prime = prime;
        return this;
    }

    public ShamirSharesBuilder mersennePrimeExponent(int mersennePrimeExponent) {
        this.prime = BigInteger.ONE.shiftLeft(mersennePrimeExponent).subtract(BigInteger.ONE);
        return this;
    }

    public ShamirSharesBuilder validatePrime() {
        ShamirSharesBuilder.validatePrime(this.prime);
        return this;
    }

    public ShamirSharesBuilder validateAndSetPrime(BigInteger prime) {
        ShamirSharesBuilder.validatePrime(prime);
        this.prime = prime;
        return this;
    }

    private static void validatePrime(BigInteger prime) {
        if (!prime.isProbablePrime(Integer.MAX_VALUE)) {
            throw new IllegalStateException("This is not a prime number: " + prime);
        }
    }

    public ShamirSharesBuilder numShares(int numShares) {
        this.numShares = numShares;
        return this;
    }

    public ShamirSharesBuilder numRequiredShares(int numRequiredShares) {
        if (this.secrets == null) {
            this.secrets = new BigInteger[numRequiredShares];
            return this;
        }
        if (this.secrets.length != numRequiredShares) {
            BigInteger[] newSecretsArray = new BigInteger[numRequiredShares];
            System.arraycopy(this.secrets, 0, newSecretsArray, 0, Math.min(this.secrets.length, numRequiredShares));
            this.secrets = newSecretsArray;
        }
        return this;
    }

    public ShamirSharesBuilder initSecrets(byte[] secretBytes) {
        return this.initSecrets(new BigInteger(1, secretBytes));
    }

    public ShamirSharesBuilder initSecrets(BigInteger secret) {
        if (this.prime == null) {
            this.prime = secret.nextProbablePrime();
        }
        if (secret.compareTo(BigInteger.ZERO) <= 0 || secret.compareTo(this.prime) >= 0) {
            throw new IllegalArgumentException("Secret must be greater than 0 and less than the prime " + this.prime);
        }
        this.initSecureRandom();
        this.initSecretsUnchecked(secret);
        return this;
    }

    public ShamirSharesBuilder initSecrets() {
        Objects.requireNonNull(this.prime, "Prime must be set.");
        this.initSecureRandom();
        this.initSecretsUnchecked(Shamir.createSecret(this.secureRandom, this.prime));
        return this;
    }

    private void initSecureRandom() {
        if (this.secureRandom == null) {
            this.secureRandom = new SecureRandom();
        }
    }

    private void initSecretsUnchecked(BigInteger secret) {
        this.secrets[0] = secret;
        for (int i = 1; i < this.secrets.length; ++i) {
            this.secrets[i] = Shamir.createSecret(this.secureRandom, this.prime);
        }
    }

    public ShamirSharesBuilder clearSecret(int index) {
        this.secrets[index] = null;
        return this;
    }

    public ShamirSharesBuilder clearSecrets() {
        Arrays.fill(this.secrets, null);
        return this;
    }

    public BigInteger[] createShares() {
        return Shamir.createShares(this.prime, this.secrets, this.numShares);
    }

    public int validateShareCombinations(BigInteger[] shares) {
        return Shamir.validateShareCombinations(this.secrets[0], this.prime, this.secrets.length, shares);
    }

    public String toString() {
        return "{\"_class\":\"ShamirSharesBuilder\", \"prime\":" + (Serializable)(this.prime == null ? "null" : this.prime) + ", \"numShares\":\"" + this.numShares + "\", \"numRequiredShares\":\"" + this.getNumRequiredShares() + "\", \"secrets\":" + Arrays.toString(this.secrets) + "}";
    }
}

