/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.shamir;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.IntStream;
import systems.comodal.shamir.ShamirSharesBuilder;

public final class Shamir {
    private Shamir() {
    }

    public static ShamirSharesBuilder buildShares() {
        return new ShamirSharesBuilder();
    }

    public static BigInteger[] createSecrets(Random secureRandom, BigInteger prime, int requiredShares) {
        BigInteger[] secrets = new BigInteger[requiredShares];
        Shamir.createSecrets(secureRandom, prime, secrets);
        return secrets;
    }

    public static void createSecrets(Random secureRandom, BigInteger prime, BigInteger[] secrets) {
        for (int i = 0; i < secrets.length; ++i) {
            secrets[i] = Shamir.createSecret(secureRandom, prime);
        }
    }

    public static BigInteger createSecret(Random secureRandom, BigInteger prime) {
        BigInteger secret;
        while ((secret = new BigInteger(prime.bitLength(), secureRandom)).compareTo(BigInteger.ZERO) <= 0 || secret.compareTo(prime) >= 0) {
        }
        return secret;
    }

    public static BigInteger[] createShares(BigInteger prime, BigInteger[] secrets, int numShares) {
        BigInteger[] shares = new BigInteger[numShares];
        for (int shareIndex = 0; shareIndex < numShares; ++shareIndex) {
            BigInteger result = secrets[0];
            BigInteger sharePosition = BigInteger.valueOf(shareIndex + 1);
            for (int exp = 1; exp < secrets.length; ++exp) {
                result = result.add(secrets[exp].multiply(sharePosition.pow(exp).mod(prime))).mod(prime);
            }
            shares[shareIndex] = result;
        }
        return shares;
    }

    public static BigInteger reconstructSecret(Map<BigInteger, BigInteger> shares, BigInteger prime) {
        Set<Map.Entry<BigInteger, BigInteger>> shareEntries = shares.entrySet();
        BigInteger freeCoefficient = BigInteger.ZERO;
        for (Map.Entry<BigInteger, BigInteger> referenceEntry : shareEntries) {
            BigInteger numerator = BigInteger.ONE;
            BigInteger denominator = BigInteger.ONE;
            BigInteger referencePosition = referenceEntry.getKey();
            for (Map.Entry<BigInteger, BigInteger> shareEntry : shareEntries) {
                BigInteger position = shareEntry.getKey();
                if (referencePosition.equals(position)) continue;
                numerator = numerator.multiply(position.negate()).mod(prime);
                denominator = denominator.multiply(referencePosition.subtract(position)).mod(prime);
            }
            BigInteger share = referenceEntry.getValue();
            freeCoefficient = prime.add(freeCoefficient).add(share.multiply(numerator).multiply(denominator.modInverse(prime))).mod(prime);
        }
        return freeCoefficient;
    }

    private static BigInteger reconstructSecret(Map.Entry<BigInteger, BigInteger>[] shares, BigInteger prime) {
        BigInteger freeCoefficient = BigInteger.ZERO;
        for (Map.Entry<BigInteger, BigInteger> referenceEntry : shares) {
            BigInteger numerator = BigInteger.ONE;
            BigInteger denominator = BigInteger.ONE;
            BigInteger referencePosition = referenceEntry.getKey();
            for (Map.Entry<BigInteger, BigInteger> shareEntry : shares) {
                BigInteger position = shareEntry.getKey();
                if (referencePosition.equals(position)) continue;
                numerator = numerator.multiply(position.negate()).mod(prime);
                denominator = denominator.multiply(referencePosition.subtract(position)).mod(prime);
            }
            BigInteger share = referenceEntry.getValue();
            freeCoefficient = prime.add(freeCoefficient).add(share.multiply(numerator).multiply(denominator.modInverse(prime))).mod(prime);
        }
        return freeCoefficient;
    }

    public static int validateShareCombinations(BigInteger expectedSecret, BigInteger prime, int numRequiredShares, BigInteger[] shares) {
        Map.Entry[] points = (Map.Entry[])IntStream.range(0, shares.length).mapToObj(i -> Map.entry(BigInteger.valueOf(i + 1), shares[i])).toArray(Map.Entry[]::new);
        return Shamir.shareCombinations(points, 0, numRequiredShares, new Map.Entry[numRequiredShares], expectedSecret, prime);
    }

    private static int shareCombinations(Map.Entry<BigInteger, BigInteger>[] points, int startPos, int len, Map.Entry<BigInteger, BigInteger>[] result, BigInteger expectedSecret, BigInteger prime) {
        if (len == 0) {
            Shamir.validateReconstruction(expectedSecret, prime, result);
            return 1;
        }
        int numSubSets = 0;
        for (int i = startPos; i <= points.length - len; ++i) {
            result[result.length - len] = points[i];
            numSubSets += Shamir.shareCombinations(points, i + 1, len - 1, result, expectedSecret, prime);
        }
        return numSubSets;
    }

    private static void validateReconstruction(BigInteger expectedSecret, BigInteger prime, Map.Entry<BigInteger, BigInteger>[] shares) {
        BigInteger reconstructedSecret = Shamir.reconstructSecret(shares, prime);
        if (!expectedSecret.equals(reconstructedSecret)) {
            throw new IllegalStateException(String.format("Reconstructed secret does not equal expected secret. %nReconstructed: '%s' %nExpected: '%s' %nWith %d shares: %n%s", reconstructedSecret, expectedSecret, shares.length, Arrays.toString(shares)));
        }
    }
}

