/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.shamir;

import java.math.BigInteger;
import java.util.Map;
import java.util.Random;
import java.util.stream.IntStream;
import systems.comodal.shamir.ShamirSharesBuilder;

public final class Shamir {
    private Shamir() {
    }

    public static ShamirSharesBuilder buildShares() {
        return new ShamirSharesBuilder();
    }

    public static BigInteger[] createSecrets(Random secureRandom, BigInteger prime, int requiredShares) {
        BigInteger[] secrets = new BigInteger[requiredShares];
        Shamir.createSecrets(secureRandom, prime, secrets);
        return secrets;
    }

    public static void createSecrets(Random secureRandom, BigInteger prime, BigInteger[] secrets) {
        for (int i = 0; i < secrets.length; ++i) {
            secrets[i] = Shamir.createSecret(secureRandom, prime);
        }
    }

    public static BigInteger createSecret(Random secureRandom, BigInteger prime) {
        BigInteger secret;
        while ((secret = new BigInteger(prime.bitLength(), secureRandom)).compareTo(BigInteger.ZERO) <= 0 || secret.compareTo(prime) >= 0) {
        }
        return secret;
    }

    public static BigInteger[] createShares(BigInteger prime, BigInteger[] secrets, int numShares) {
        BigInteger[] shares = new BigInteger[numShares];
        for (int shareIndex = 0; shareIndex < numShares; ++shareIndex) {
            BigInteger result = secrets[0];
            BigInteger sharePosition = BigInteger.valueOf(shareIndex + 1);
            for (int exp = 1; exp < secrets.length; ++exp) {
                result = result.add(secrets[exp].multiply(sharePosition.pow(exp).mod(prime))).mod(prime);
            }
            shares[shareIndex] = result;
        }
        return shares;
    }

    public static BigInteger reconstructSecret(Map<BigInteger, BigInteger> shares, BigInteger prime) {
        BigInteger freeCoefficient = BigInteger.ZERO;
        for (Map.Entry<BigInteger, BigInteger> referenceEntry : shares.entrySet()) {
            BigInteger numerator = BigInteger.ONE;
            BigInteger denominator = BigInteger.ONE;
            BigInteger referencePosition = referenceEntry.getKey();
            for (Map.Entry<BigInteger, BigInteger> shareEntry : shares.entrySet()) {
                BigInteger position = shareEntry.getKey();
                if (referencePosition.equals(position)) continue;
                numerator = numerator.multiply(position.negate()).mod(prime);
                denominator = denominator.multiply(referencePosition.subtract(position)).mod(prime);
            }
            BigInteger share = referenceEntry.getValue();
            freeCoefficient = prime.add(freeCoefficient).add(share.multiply(numerator).multiply(denominator.modInverse(prime))).mod(prime);
        }
        return freeCoefficient;
    }

    public static int validateShareCombinations(BigInteger expectedSecret, BigInteger prime, int numRequiredShares, BigInteger[] shares) {
        BigInteger[] positions = (BigInteger[])IntStream.rangeClosed(1, shares.length).mapToObj(BigInteger::valueOf).toArray(BigInteger[]::new);
        return Shamir.shareCombinations(shares, 0, numRequiredShares, new Map.Entry[numRequiredShares], expectedSecret, prime, positions);
    }

    private static int shareCombinations(BigInteger[] shares, int startPos, int len, Map.Entry<BigInteger, BigInteger>[] result, BigInteger expectedSecret, BigInteger prime, BigInteger[] cachedPositions) {
        if (len == 0) {
            Shamir.validateReconstruction(expectedSecret, prime, Map.ofEntries(result));
            return 1;
        }
        int numSubSets = 0;
        for (int i = startPos; i <= shares.length - len; ++i) {
            int r = result.length - len;
            result[r] = Map.entry(cachedPositions[i], shares[i]);
            numSubSets += Shamir.shareCombinations(shares, i + 1, len - 1, result, expectedSecret, prime, cachedPositions);
        }
        return numSubSets;
    }

    private static void validateReconstruction(BigInteger expectedSecret, BigInteger prime, Map<BigInteger, BigInteger> shareMap) {
        BigInteger reconstructedSecret = Shamir.reconstructSecret(shareMap, prime);
        if (!expectedSecret.equals(reconstructedSecret)) {
            throw new IllegalStateException(String.format("Reconstructed secret does not equal expected secret. %nReconstructed: '%s' %nExpected: '%s' %nWith %d shares: %n%s", reconstructedSecret, expectedSecret, shareMap.size(), shareMap));
        }
    }
}

