/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.shamir;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.IntStream;
import systems.comodal.shamir.Shamir;

public final class ShamirSharesBuilder {
    private SecureRandom secureRandom;
    private BigInteger prime;
    private int numShares;
    private int numRequiredShares;
    private BigInteger[] secrets;

    ShamirSharesBuilder() {
    }

    public BigInteger getPrime() {
        return this.prime;
    }

    public int getNumShares() {
        return this.numShares;
    }

    public int getNumRequiredShares() {
        return this.numRequiredShares;
    }

    public BigInteger getSecret() {
        return this.secrets == null ? null : this.secrets[0];
    }

    public ShamirSharesBuilder secureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    public ShamirSharesBuilder prime(BigInteger prime) {
        this.prime = prime;
        return this;
    }

    public ShamirSharesBuilder mersennePrimeExponent(int mersennePrimeExponent) {
        this.prime = BigInteger.ONE.shiftLeft(mersennePrimeExponent).subtract(BigInteger.ONE);
        return this;
    }

    public ShamirSharesBuilder validatePrime() {
        ShamirSharesBuilder.validatePrime(this.prime);
        return this;
    }

    public ShamirSharesBuilder validateAndSetPrime(BigInteger prime) {
        ShamirSharesBuilder.validatePrime(prime);
        this.prime = prime;
        return this;
    }

    private static void validatePrime(BigInteger prime) {
        if (!prime.isProbablePrime(Integer.MAX_VALUE)) {
            throw new IllegalStateException("This is probably not a prime number using a certainty of Integer.MAX_VALUE: " + prime);
        }
    }

    public ShamirSharesBuilder numShares(int numShares) {
        this.numShares = numShares;
        return this;
    }

    public ShamirSharesBuilder numRequiredShares(int numRequiredShares) {
        this.numRequiredShares = numRequiredShares;
        return this;
    }

    public ShamirSharesBuilder initSecrets(BigInteger secret) {
        if (secret.compareTo(BigInteger.ZERO) <= 0 || secret.compareTo(this.prime) >= 0) {
            throw new IllegalArgumentException("Secret must be greater than 0 and less than the prime " + this.prime);
        }
        this.initSecureRandom();
        this.initSecretsUnchecked(secret);
        return this;
    }

    private void initSecureRandom() {
        if (this.secureRandom == null) {
            this.secureRandom = new SecureRandom();
        }
    }

    public ShamirSharesBuilder initSecrets() {
        this.initSecureRandom();
        this.initSecretsUnchecked(Shamir.createSecret(this.secureRandom, this.prime));
        return this;
    }

    private void initSecretsUnchecked(BigInteger secret) {
        if (this.secrets == null || this.secrets.length != this.numRequiredShares) {
            this.secrets = new BigInteger[this.numRequiredShares];
        }
        this.secrets[0] = secret;
        for (int i = 1; i < this.numRequiredShares; ++i) {
            this.secrets[i] = Shamir.createSecret(this.secureRandom, this.prime);
        }
    }

    public ShamirSharesBuilder clearSecret(int index) {
        this.secrets[index] = null;
        return this;
    }

    public ShamirSharesBuilder clearSecrets() {
        Arrays.fill(this.secrets, null);
        return this;
    }

    public BigInteger[] createShares() {
        return Shamir.createShares(this.prime, this.secrets, this.numShares);
    }

    private void validateReconstruction(BigInteger expectedSecret, Map<BigInteger, BigInteger> shareMap) {
        BigInteger reconstructedSecret = Shamir.reconstructSecret(shareMap, this.prime);
        if (shareMap.size() != this.numRequiredShares) {
            throw new IllegalStateException(String.format("Share map should have exactly %d shares, but found %d.%n%s", this.numRequiredShares, shareMap.size(), shareMap));
        }
        if (!expectedSecret.equals(reconstructedSecret)) {
            throw new IllegalStateException(String.format("Reconstructed secret does not equal expected secret. %nReconstructed: '%s' %nExpected: '%s' %nWith %d shares: %n%s", reconstructedSecret, expectedSecret, shareMap.size(), shareMap));
        }
    }

    public int validateShareCombinations(BigInteger[] shares) {
        BigInteger[] positions = (BigInteger[])IntStream.rangeClosed(1, this.numShares).mapToObj(BigInteger::valueOf).toArray(BigInteger[]::new);
        return this.shareCombinations(shares, 0, this.numRequiredShares, new Map.Entry[this.numRequiredShares], this.secrets[0], positions);
    }

    private int shareCombinations(BigInteger[] shares, int startPos, int len, Map.Entry<BigInteger, BigInteger>[] result, BigInteger expectedSecret, BigInteger[] cachedPositions) {
        if (len == 0) {
            this.validateReconstruction(expectedSecret, Map.ofEntries(result));
            return 1;
        }
        int numSubSets = 0;
        for (int i = startPos; i <= shares.length - len; ++i) {
            int r = result.length - len;
            result[r] = Map.entry(cachedPositions[i], shares[i]);
            numSubSets += this.shareCombinations(shares, i + 1, len - 1, result, expectedSecret, cachedPositions);
        }
        return numSubSets;
    }

    public String toString() {
        return "{\"_class\":\"ShamirSharesBuilder\", \"prime\":" + (Serializable)(this.prime == null ? "null" : this.prime) + ", \"numShares\":\"" + this.numShares + "\", \"numRequiredShares\":\"" + this.numRequiredShares + "\", \"secrets\":" + Arrays.toString(this.secrets) + "}";
    }
}

