/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.redis.lua.locks;

import com.fabahaba.jedipus.client.RedisClient;
import com.fabahaba.jedipus.cluster.RedisClusterExecutor;
import com.fabahaba.jedipus.cmds.Cmd;
import com.fabahaba.jedipus.cmds.CmdByteArray;
import com.fabahaba.jedipus.cmds.RESP;
import com.fabahaba.jedipus.lua.LuaScript;
import systems.comodal.redis.locks.AcquireReply;

public final class RedisMutex {
    public static final LuaScript TRY_ACQUIRE = LuaScript.fromResourcePath((String)"/redis/locks/MUTEX.TRY_ACQUIRE.lua");
    public static final Cmd<AcquireReply> EVALSHA_ACQUIRE = Cmd.create((String)"EVALSHA", AcquireReply.ACQUIRE_REPLY_ADAPTER);
    public static final Cmd<Object[]> EVALSHA_ACQUIRE_RAW = Cmd.createCast((String)"EVALSHA");
    public static final LuaScript TRY_RELEASE = LuaScript.fromResourcePath((String)"/redis/locks/MUTEX.TRY_RELEASE.lua");
    public static final Cmd<String> EVALSHA_RELEASE = Cmd.createStringReply((String)"EVALSHA");
    public static final Cmd<byte[]> EVALSHA_RELEASE_RAW = Cmd.createCast((String)"EVALSHA");
    private static final byte[] NUM_KEYS = RESP.toBytes((int)1);

    private RedisMutex() {
    }

    public static void loadMissingScripts(RedisClusterExecutor rce) {
        LuaScript.loadMissingScripts((RedisClusterExecutor)rce, (LuaScript[])new LuaScript[]{TRY_ACQUIRE, TRY_RELEASE});
    }

    public static void loadMissingScripts(RedisClient client) {
        LuaScript.loadMissingScripts((RedisClient)client, (LuaScript[])new LuaScript[]{TRY_ACQUIRE, TRY_RELEASE});
    }

    public static CmdByteArray<AcquireReply> createDirectAcquireArgs(String lockName, String ownerId, long pexpire) {
        return CmdByteArray.startBuilding(EVALSHA_ACQUIRE, (int)6).addArg(TRY_ACQUIRE.getSha1HexBytes()).addArg(NUM_KEYS).addSlotKey(lockName).addArg(ownerId).addArg(pexpire).create();
    }

    public static CmdByteArray<Object[]> createDirectAcquireArgs(byte[] lockName, byte[] ownerId, byte[] pexpire) {
        return CmdByteArray.startBuilding(EVALSHA_ACQUIRE_RAW, (int)6).addArg(TRY_ACQUIRE.getSha1HexBytes()).addArg(NUM_KEYS).addSlotKey(lockName).addArg(ownerId).addArg(pexpire).create();
    }

    public static CmdByteArray<String> createDirectReleaseArgs(String lockName, String ownerId) {
        return CmdByteArray.startBuilding(EVALSHA_RELEASE, (int)5).addArg(TRY_RELEASE.getSha1HexBytes()).addArg(NUM_KEYS).addSlotKey(lockName).addArg(ownerId).create();
    }

    public static CmdByteArray<byte[]> createDirectReleaseArgs(byte[] lockName, byte[] ownerId) {
        return CmdByteArray.startBuilding(EVALSHA_RELEASE_RAW, (int)5).addArg(TRY_RELEASE.getSha1HexBytes()).addArg(NUM_KEYS).addSlotKey(lockName).addArg(ownerId).create();
    }
}

