/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.util;

import com.pusher.client.util.ConnectionFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;

public final class UrlEncodedConnectionFactory
extends ConnectionFactory {
    private Map<String, String> mQueryStringParameters = Collections.emptyMap();

    public UrlEncodedConnectionFactory() {
    }

    public UrlEncodedConnectionFactory(Map<String, String> queryStringParameters) {
        this.mQueryStringParameters = queryStringParameters;
    }

    @Override
    public String getCharset() {
        return "UTF-8";
    }

    @Override
    public String getContentType() {
        return "application/x-www-form-urlencoded";
    }

    @Override
    public String getBody() {
        StringBuilder urlParameters = new StringBuilder();
        try {
            urlParameters.append("channel_name=").append(URLEncoder.encode(this.getChannelName(), this.getCharset()));
            urlParameters.append("&socket_id=").append(URLEncoder.encode(this.getSocketId(), this.getCharset()));
            this.mQueryStringParameters.forEach((parameterName, val) -> {
                urlParameters.append("&").append((String)parameterName).append("=");
                try {
                    urlParameters.append(URLEncoder.encode(val, this.getCharset()));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return urlParameters.toString();
    }
}

