package com.pusher.client.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * Form URL-Encoded ConnectionManager Factory
 * <p>
 * Allows HttpAuthorizer to write URL parameters to the connection
 */
public final class UrlEncodedConnectionFactory extends ConnectionFactory {

  private Map<String, String> mQueryStringParameters = Collections.emptyMap();

  /**
   * Create a Form URL-encoded factory
   */
  public UrlEncodedConnectionFactory() {
  }

  /**
   * Create a Form URL-encoded factory
   *
   * @param queryStringParameters extra parameters that need to be added to query string.
   */
  public UrlEncodedConnectionFactory(final Map<String, String> queryStringParameters) {
    this.mQueryStringParameters = queryStringParameters;
  }

  @Override
  public String getCharset() {
    return "UTF-8";
  }

  @Override
  public String getContentType() {
    return "application/x-www-form-urlencoded";
  }

  public String getBody() {
    final var urlParameters = new StringBuilder();
    try {
      urlParameters.append("channel_name=").append(URLEncoder.encode(getChannelName(), getCharset()));
      urlParameters.append("&socket_id=").append(URLEncoder.encode(getSocketId(), getCharset()));
      // Adding extra parameters supplied to be added to query string.
      mQueryStringParameters.forEach((parameterName, val) -> {
        urlParameters.append("&").append(parameterName).append("=");
        try {
          urlParameters.append(URLEncoder.encode(val, getCharset()));
        } catch (UnsupportedEncodingException e) {
          e.printStackTrace();
        }
      });
    } catch (UnsupportedEncodingException e) {
      e.printStackTrace();
    }
    return urlParameters.toString();
  }
}