package com.pusher.client;

import com.pusher.client.channel.*;
import com.pusher.client.connection.ConnectionEventListener;
import com.pusher.client.connection.ConnectionManager;
import com.pusher.client.connection.ConnectionState;

import java.util.Collection;

/**
 * Created by jamiepatel on 09/06/2016.
 */
public interface Client {

  ConnectionManager getConnectionManager();

  void connect();

  void connect(final ConnectionEventListener eventListener);

  void connect(final ConnectionEventListener eventListener, final Collection<ConnectionState> connectionStates);

  void disconnect();

  Channel subscribe(final String channelName);

  Channel subscribe(final String channelName, final ChannelEventListener channelEventListener);

  default Channel subscribe(final String channelName,
                            final ChannelEventListener channelEventListener,
                            final Iterable<String> eventNames) {
    return subscribe(channelName, channelEventListener, channelEventListener, eventNames);
  }

  Channel subscribe(final String channelName,
                    final ChannelEventListener channelEventListener,
                    final DataEventListener dataEventListener,
                    final Iterable<String> eventNames);

  PrivateChannel subscribePrivate(final String channelName);

  PrivateChannel subscribePrivate(final String channelName, final PrivateChannelEventListener channelEventListener);

  default PrivateChannel subscribePrivate(final String channelName,
                                          final PrivateChannelEventListener channelEventListener,
                                          final Iterable<String> eventNames) {
    return subscribePrivate(channelName, channelEventListener, channelEventListener, eventNames);
  }

  PrivateChannel subscribePrivate(final String channelName,
                                  final PrivateChannelEventListener channelEventListener,
                                  final DataEventListener dataEventListener,
                                  final Iterable<String> eventNames);

  PresenceChannel subscribePresence(final String channelName);

  PresenceChannel subscribePresence(final String channelName, final PresenceChannelEventListener channelEventListener);

  default PresenceChannel subscribePresence(final String channelName,
                                    final PresenceChannelEventListener channelEventListener,
                                    final Iterable<String> eventNames) {
    return subscribePresence(channelName, channelEventListener, channelEventListener, eventNames);
  }

  PresenceChannel subscribePresence(final String channelName,
                                    final PresenceChannelEventListener channelEventListener,
                                    final DataEventListener dataEventListener,
                                    final Iterable<String> eventNames);

  void unsubscribe(final String channelName);

  Channel getChannel(final String channelName);

  PrivateChannel getPrivateChannel(final String channelName);

  PresenceChannel getPresenceChannel(final String channelName);
}
