/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client.channel.impl;

import com.pusher.client.channel.ChannelEventListener;
import com.pusher.client.channel.ChannelState;
import com.pusher.client.channel.DataEventListener;
import com.pusher.client.channel.impl.InternalChannel;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

public class ChannelImpl<L extends ChannelEventListener>
implements InternalChannel<L> {
    private static final String INTERNAL_EVENT_PREFIX = "pusher_internal:";
    static final String SUBSCRIPTION_SUCCESS_EVENT = "pusher_internal:subscription_succeeded";
    protected final String channelName;
    private final Map<String, Set<DataEventListener>> eventNameToListenerMap;
    protected volatile ChannelState state;
    final L eventListener;
    private final Executor listenerExecutor;

    public ChannelImpl(String channelName, L eventListener, Executor listenerExecutor) {
        if (channelName == null) {
            throw new IllegalArgumentException("Cannot subscribe to a channel with a null channelName");
        }
        for (String disallowedPattern : this.getDisallowedNameExpressions()) {
            if (!channelName.matches(disallowedPattern)) continue;
            throw new IllegalArgumentException("Channel channelName " + channelName + " is invalid. Private channel names must start with \"private-\" and presence channel names must start with \"presence-\"");
        }
        this.channelName = channelName;
        this.eventListener = eventListener;
        this.eventNameToListenerMap = new ConcurrentHashMap<String, Set<DataEventListener>>();
        this.state = ChannelState.INITIAL;
        this.listenerExecutor = listenerExecutor;
    }

    @Override
    public String getChannelName() {
        return this.channelName;
    }

    @Override
    public void bind(String eventName, DataEventListener listener) {
        this.validateArguments(eventName, listener);
        this.eventNameToListenerMap.computeIfAbsent(eventName, _eventName -> Collections.newSetFromMap(new ConcurrentHashMap())).add(listener);
    }

    @Override
    public void unbind(String eventName, DataEventListener listener) {
        this.validateArguments(eventName, listener);
        Set<DataEventListener> listeners = this.eventNameToListenerMap.get(eventName);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    @Override
    public boolean isSubscribed() {
        return this.state == ChannelState.SUBSCRIBED;
    }

    @Override
    public void onMessage(String event, String rawJson) {
        if (event.equals(SUBSCRIPTION_SUCCESS_EVENT)) {
            this.updateState(ChannelState.SUBSCRIBED);
            return;
        }
        String data = ChannelImpl.getData(rawJson);
        Set<DataEventListener> listeners = this.eventNameToListenerMap.get(event);
        if ((listeners == null || listeners.isEmpty()) && this.eventListener != null) {
            this.listenerExecutor.execute(() -> this.eventListener.onEvent(this.channelName, event, data));
            return;
        }
        if (listeners == null) {
            return;
        }
        for (DataEventListener listener : listeners) {
            this.listenerExecutor.execute(() -> listener.onEvent(this.channelName, event, data));
        }
    }

    private static String getData(String json) {
        char ch;
        int index = json.indexOf("\"data\":");
        if (index < 0) {
            return null;
        }
        index += 7;
        while ((ch = json.charAt(index++)) != '\"') {
        }
        int begin = index;
        char prevCh = json.charAt(index);
        char ch2 = json.charAt(++index);
        while (ch2 != '\"' || prevCh == '\\') {
            prevCh = ch2;
            ch2 = json.charAt(++index);
        }
        return json.substring(begin, index).replace("\\\"", "\"");
    }

    @Override
    public String toSubscribeMessage() {
        return "{\"event\":\"pusher:subscribe\",\"data\":{\"channel\":\"" + this.channelName + "\"}}";
    }

    @Override
    public String toUnsubscribeMessage() {
        return "{\"event\":\"pusher:unsubscribe\",\"data\":{\"channel\":\"" + this.channelName + "\"}}";
    }

    @Override
    public void updateState(ChannelState state) {
        this.state = state;
        if (state == ChannelState.SUBSCRIBED && this.eventListener != null) {
            this.listenerExecutor.execute(() -> this.eventListener.onSubscriptionSucceeded(this.channelName));
        }
    }

    @Override
    public L getEventListener() {
        return this.eventListener;
    }

    @Override
    public int compareTo(InternalChannel other) {
        return this.channelName.compareTo(other.getChannelName());
    }

    public String toString() {
        return String.format("[Public Channel: channelName=%s]", this.channelName);
    }

    protected String[] getDisallowedNameExpressions() {
        return new String[]{"^private-.*", "^presence-.*"};
    }

    private void validateArguments(String eventName, DataEventListener listener) {
        if (eventName == null) {
            throw new IllegalArgumentException("Cannot bind or unbind to channel " + this.channelName + " with a null event channelName");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Cannot bind or unbind to channel " + this.channelName + " with a null listener");
        }
        if (eventName.startsWith(INTERNAL_EVENT_PREFIX)) {
            throw new IllegalArgumentException("Cannot bind or unbind channel " + this.channelName + " with an internal event channelName such as " + eventName);
        }
        if (this.state == ChannelState.UNSUBSCRIBED) {
            throw new IllegalStateException("Cannot bind or unbind to events on a channel that has been un-subscribed. Call Pusher.subscribe() to resubscribe to this channel");
        }
    }
}

