/*
 * Decompiled with CFR 0.152.
 */
package com.pusher.client;

import com.pusher.client.Authorizer;
import com.pusher.client.Pusher;
import com.pusher.client.channel.impl.ChannelManager;
import com.pusher.client.connection.websocket.WebSocketConnectionManager;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import jdk.incubator.http.HttpClient;

public final class PusherBuilder {
    private static final String SRC_LIB_DEV_VERSION = "@version@";
    private static final String LIB_DEV_VERSION = "0.0.0-dev";
    public static final String LIB_VERSION = PusherBuilder.readVersionFromProperties();
    private static final String URI_PARAMS = "?client=comodal&protocol=7&version=" + LIB_VERSION;
    private static final String WS_SCHEME = "ws";
    private static final String WSS_SCHEME = "wss";
    private static final int WS_PORT = 80;
    private static final int WSS_PORT = 443;
    private static final String DEFAULT_HOST = "ws.pusherapp.com";
    private static final String PUSHER_DOMAIN = "pusher.com";
    private static final long DEFAULT_ACTIVITY_TIMEOUT = 14000L;
    private static final long DEFAULT_PONG_TIMEOUT = 7000L;
    private static final int MAX_RECONNECT_GAP_IN_SECONDS = 30;
    private String cluster = null;
    private boolean encrypted = true;
    private long activityTimeout = 14000L;
    private long pongTimeout = 7000L;
    private Authorizer authorizer;
    private int maxReconnectGapInSeconds = 30;
    private HttpClient httpClient;
    private Executor listenerExecutor;

    PusherBuilder() {
    }

    public Pusher create(String apiKey) {
        return this.create("my", apiKey);
    }

    public Pusher create(String name, String apiKey) {
        if (apiKey == null || apiKey.length() == 0) {
            throw new IllegalArgumentException("API Key cannot be null or empty");
        }
        return this.create(name, PusherBuilder.createURI(this.encrypted, this.cluster, apiKey));
    }

    public Pusher create(String name, URI uri) {
        Executor listenerExecutor = this.listenerExecutor == null ? ForkJoinPool.commonPool() : this.listenerExecutor;
        ChannelManager channelManager = new ChannelManager(listenerExecutor);
        WebSocketConnectionManager connectionManager = new WebSocketConnectionManager(name, uri, this.httpClient, channelManager, this.activityTimeout, this.pongTimeout, this.maxReconnectGapInSeconds, listenerExecutor);
        channelManager.setConnection(connectionManager);
        return new Pusher(listenerExecutor, channelManager, connectionManager, this.authorizer);
    }

    public Executor getListenerExecutor() {
        return this.listenerExecutor;
    }

    public PusherBuilder setListenerExecutor(Executor listenerExecutor) {
        this.listenerExecutor = listenerExecutor;
        return this;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public PusherBuilder setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public PusherBuilder setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
        return this;
    }

    public Authorizer getAuthorizer() {
        return this.authorizer;
    }

    public PusherBuilder setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
        return this;
    }

    public PusherBuilder setCluster(String cluster) {
        this.cluster = cluster;
        return this;
    }

    public String getCluster() {
        return this.cluster;
    }

    public PusherBuilder setActivityTimeout(long activityTimeout) {
        if (activityTimeout < 1000L) {
            throw new IllegalArgumentException("Activity timeout must be at least 1,000ms (and is recommended to be much higher)");
        }
        this.activityTimeout = activityTimeout;
        return this;
    }

    public long getActivityTimeout() {
        return this.activityTimeout;
    }

    public PusherBuilder setPongTimeout(long pongTimeout) {
        if (pongTimeout < 1000L) {
            throw new IllegalArgumentException("Pong timeout must be at least 1,000ms (and is recommended to be much higher)");
        }
        this.pongTimeout = pongTimeout;
        return this;
    }

    public PusherBuilder setMaxReconnectGapInSeconds(int maxReconnectGapInSeconds) {
        this.maxReconnectGapInSeconds = maxReconnectGapInSeconds;
        return this;
    }

    public long getPongTimeout() {
        return this.pongTimeout;
    }

    public static URI createURI(boolean encrypted, String apiKey) {
        return PusherBuilder.createURI(encrypted, null, apiKey);
    }

    public static URI createURI(boolean encrypted, String cluster, String apiKey) {
        return URI.create((encrypted ? WSS_SCHEME : WS_SCHEME) + "://" + (String)(cluster == null ? WS_SCHEME : "ws-" + cluster) + ".pusher.com:" + (encrypted ? 443 : 80) + "/app/" + apiKey + URI_PARAMS);
    }

    public int getMaxReconnectGapInSeconds() {
        return this.maxReconnectGapInSeconds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readVersionFromProperties() {
        try (InputStream inStream = PusherBuilder.class.getResourceAsStream("/pusher.properties");){
            Properties p = new Properties();
            p.load(inStream);
            String version = (String)p.get("version");
            if (version == null) return "0.0.0";
            if (version.isEmpty()) return "0.0.0";
            String string = version.equals(SRC_LIB_DEV_VERSION) ? LIB_DEV_VERSION : version;
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "0.0.0";
    }
}

